% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_correlation.R
\name{run_correlation}
\alias{run_correlation}
\title{Run Correlation Analysis}
\usage{
run_correlation(
  exposomicset,
  feature_type = c("degs", "omics", "factors", "factor_features", "exposures", "pcs"),
  exposure_cols = NULL,
  variable_map = NULL,
  n_pcs = NULL,
  feature_cors = FALSE,
  robust = FALSE,
  score_col = "stability_score",
  score_thresh = NULL,
  correlation_method = "spearman",
  correlation_cutoff = 0.3,
  cor_pval_column = "p.value",
  pval_cutoff = 0.05,
  deg_pval_col = "adj.P.Val",
  deg_logfc_col = "logFC",
  deg_pval_thresh = 0.05,
  deg_logfc_thresh = log2(1.5),
  batch_size = 1500,
  action = c("add", "get")
)
}
\arguments{
\item{exposomicset}{A \code{MultiAssayExperiment} object.}

\item{feature_type}{Type of features to correlate. One of \code{"degs"},
\code{"omics"}, \code{"factors"}, \code{"factor_features"}, \code{"exposures"}, or \code{"pcs"}.}

\item{exposure_cols}{Optional vector of exposure column names
(from \code{colData}) to use.}

\item{variable_map}{Optional mapping of features to include by assay
for \code{omics} mode.}

\item{n_pcs}{Number of PCs to use when \code{feature_type = "pcs"}.}

\item{feature_cors}{Logical; if \code{TRUE}, compute correlations between
features rather than with exposures.}

\item{robust}{Logical; restrict DEGs to those passing sensitivity threshold.}

\item{score_col}{Column name in sensitivity analysis with feature
stability score.}

\item{score_thresh}{Threshold for filtering robust features.}

\item{correlation_method}{One of \code{"pearson"}, \code{"spearman"}, or \code{"kendall"}.}

\item{correlation_cutoff}{Minimum absolute correlation to retain.}

\item{cor_pval_column}{Column in output to filter by p-value
(default: \code{"p.value"}).}

\item{pval_cutoff}{Maximum p-value or FDR threshold to retain a correlation.}

\item{deg_pval_col}{Column with DEG adjusted p-values.}

\item{deg_logfc_col}{Column with DEG log fold-changes.}

\item{deg_pval_thresh}{P-value cutoff for DEGs.}

\item{deg_logfc_thresh}{Log fold-change cutoff for DEGs.}

\item{batch_size}{Number of features to process per batch (default: 1500).}

\item{action}{Whether to \code{"add"} results to metadata or \code{"get"}
as a data frame.}
}
\value{
If \code{action = "add"}, returns updated \code{MultiAssayExperiment}
with results added to metadata.
If \code{action = "get"}, returns a tidy \code{data.frame} of correlations.
}
\description{
Computes correlations between exposures and feature types including DEGs,
omics, latent factors,
top factor features, or principal components (PCs). Optionally computes
feature-feature correlations
to support network analysis.
}
\examples{
# create example data
mae <- make_example_data(
    n_samples = 10,
    return_mae = TRUE
)

# run correlation analysis
mae <- mae |>
    run_correlation(
        feature_type = "exposures",
        exposure_cols = c("exposure_pm25", "exposure_no2", "age", "bmi")
    )

}
