% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_top_factor_features.R
\name{plot_top_factor_features}
\alias{plot_top_factor_features}
\title{Plot Top Features by Factor from Integration Results}
\usage{
plot_top_factor_features(
  exposomicset,
  feature_col = "feature",
  factors = NULL,
  top_n = 5,
  facet_cols = NULL,
  exp_name_cols = NULL,
  alpha = 0.5
)
}
\arguments{
\item{exposomicset}{A \code{MultiAssayExperiment} object containing
integration results in the \code{metadata} slot (must include \code{integration_results}).}

\item{feature_col}{A character string indicating the column name to use
for y-axis feature labels (e.g., \code{"feature"}, \code{"gene_symbol"}). This should
match a column in the output of \code{pivot_feature()}. Default is \code{"feature"}.}

\item{factors}{Character vector of factors to include
(e.g., "Factor1", "Factor2"). If \code{NULL}, all factors are plotted.}

\item{top_n}{Integer specifying the number of top features to show
per factor. Default is \code{5}.}

\item{facet_cols}{Optional color palette for facet strip backgrounds
(one per \code{exp_name}), used to distinguish factors.}

\item{exp_name_cols}{Optional color palette for experiment labels
in the plot (\code{exp_name}), passed to \code{scale_color_manual()}.}

\item{alpha}{Numeric value between 0 and 1 controlling the
transparency of facet strip background fill. Default is \code{0.5}.}
}
\value{
A \code{ggplot2} object with one facet per factor, showing the
top features and their loadings by experiment.
}
\description{
Visualizes the top loading features for each factor from multi-omics
integration results (e.g., MOFA, MCIA, DIABLO, RGCCA).
}
\details{
This function supports the following integration methods:
\itemize{
\item \code{"MOFA"}: Uses feature weights from MOFA2 (\code{get_weights()}).
\item \code{"MCIA"}: Uses block loadings from MCIA (\verb{@block_loadings}).
\item \code{"DIABLO"}: Extracts block-specific loadings from \code{loadings}.
\item \code{"RGCCA"}: Extracts block-specific loadings from \code{a}.
}

For each factor, it:
\itemize{
\item Selects the top \code{top_n} features by \strong{absolute loading}.
\item Merges with feature metadata using \code{pivot_feature()}.
\item Creates a point-range plot showing the loading magnitude.
\item Facets each factor with a customizable strip background.
}

The \code{feature_col} argument allows you to control which feature-level
metadata column (e.g., gene symbols, metabolite names) is used for
labeling the y-axis.

If palettes are not provided, defaults are chosen using
\code{ggpubr::get_palette()}.
}
\examples{
# create example data
mae <- make_example_data(
    n_samples = 20,
    return_mae = TRUE
)

mae <- run_multiomics_integration(
    mae,
    method = "DIABLO",
    outcome = "smoker",
    n_factors = 3
)

# plot top features using default `feature` column
top_feature_p <- mae |>
    plot_top_factor_features()

}
