% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_pca.R
\name{plot_pca}
\alias{plot_pca}
\title{Plot PCA Results for Features and Samples}
\usage{
plot_pca(
  exposomicset,
  feature_col = "#00a9b2",
  sample_col = "#8a4f77",
  sample_outlier_col = "firebrick"
)
}
\arguments{
\item{exposomicset}{A \code{MultiAssayExperiment} object containing PCA results
in \code{metadata(exposomicset)$pca}.}

\item{feature_col}{A character string specifying the color for the
feature scree plot.
Default is \code{"#00a9b2"}.}

\item{sample_col}{A character string specifying the color for the
sample scree plot.
Default is \code{"#8a4f77"}.}

\item{sample_outlier_col}{A character string specifying the color
for sample outlier labels.
Default is \code{"firebrick"}.}
}
\value{
A combined \code{ggplot} object containing the four PCA plots.
}
\description{
Generates PCA plots for both feature space and sample space,
including scatter plots and scree plots.
}
\details{
This function creates four PCA visualizations:
\itemize{
\item \strong{Feature Space PCA Plot}: Colored by category (e.g., omics, exposure).
\item \strong{Feature Scree Plot}: Displays the variance explained by each
principal component.
\item \strong{Sample Space PCA Plot}: Highlights outlier samples.
\item \strong{Sample Scree Plot}: Displays variance explained in the sample PCA.
}

Outliers are labeled based on \code{metadata(exposomicset)$pca$outliers}.
}
\examples{
# create example data
mae <- make_example_data(
    n_samples = 10,
    return_mae = TRUE
)

# run pca
mae <- mae |>
    run_pca()

# create the pca plot
pca_p <- mae |>
    plot_pca()

}
