% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_normality_summary.R
\name{plot_normality_summary}
\alias{plot_normality_summary}
\title{Plot Normality Summary of Exposure Variables}
\usage{
plot_normality_summary(exposomicset, transformed = FALSE)
}
\arguments{
\item{exposomicset}{A \code{MultiAssayExperiment} object with quality control
metadata.}

\item{transformed}{Logical; if \code{TRUE}, use results after transformation.
Default is \code{FALSE}.}
}
\value{
A \code{ggplot} object summarizing the number of exposures
classified as normal or not normal.
}
\description{
Generates a bar plot summarizing the number of exposure variables that
pass or fail normality
tests (e.g., Shapiro-Wilk) before or after transformation.
}
\details{
This function assumes that \code{run_normality_check()} has been executed and
that the results are
stored in \code{metadata(exposomicset)$quality_control$normality}.
If \code{transformed = TRUE}, the function will
instead plot the transformation summary stored in \code{metadata(exposomicset)$quality_control$transformation$norm_summary},
which is populated by \code{transform_exposure()}.

The plot includes both bar heights and overlaid line segments to
reinforce the counts.
}
\examples{
# Create example data
mae <- make_example_data(
    n_samples = 20,
    return_mae = TRUE
)

# Test for normality
mae <- mae |>
    run_normality_check() |>
    transform_exposure(exposure_cols = c("age", "bmi", "exposure_pm25"))

# plot the normality summary
norm_p <- mae |>
    plot_normality_summary()

}
