% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_missing.R
\name{plot_missing}
\alias{plot_missing}
\title{Plot Missing Data Across Exposure and Omic Layers}
\usage{
plot_missing(
  exposomicset,
  threshold = 5,
  plot_type = c("summary", "lollipop"),
  layers = NULL
)
}
\arguments{
\item{exposomicset}{A \code{MultiAssayExperiment} object containing exposure
and omics assays. Missing data is inferred directly from the assays.}

\item{threshold}{Numeric. The percentage threshold (0-100) above which
features are counted as missing in the summary plot. Default is \code{5}.}

\item{plot_type}{Character. Type of plot to generate. Either \code{"summary"}
for a bar plot showing number of features above the missing threshold,
or \code{"lollipop"} for a per-feature lollipop plot with layer annotations.
Default is \code{"summary"}.}

\item{layers}{Optional character vector. If specified, filters the plot
to include only selected layers (e.g., \code{"Exposure"}, \code{"Transcriptome"}).}
}
\value{
A \code{ggplot} or \code{patchwork} object depending on the selected
\code{plot_type}.
}
\description{
Visualizes missing data patterns in a \code{MultiAssayExperiment} object using
summary bar plots or feature-level lollipop plots.
}
\details{
The function calculates missing data per feature (or variable) across all
assays (including exposure variables) and generates:
\itemize{
\item \strong{Summary plot (\verb{plot_type = "summary})}: A bar plot showing the number
of variables in each assay exceeding the specified missingness threshold.
\item \strong{Lollipop plot (\verb{plot_type = "lollipop})}: A feature-level plot where
each feature's percent missingness is shown, along with a color-coded tile
on the side indicating its layer of origin.
}

The tile colors in the lollipop plot match the experiment colors used in
other visualizations (e.g., via \code{scale_color_tidy_exp()}).
}
\examples{

#' # Create example data
mae <- make_example_data(
    n_samples = 20,
    return_mae = TRUE
)

# Introduce some missingness
MultiAssayExperiment::colData(mae)$exposure_pm25[sample(1:20, 5)] <- NA

# Summary bar plot of missing data
summary_p <- plot_missing(
    mae,
    threshold = 10,
    plot_type = "summary"
)

# Lollipop plot for all features with any missingness
lollipop_p <- plot_missing(
    mae,
    plot_type = "lollipop"
)

}
