% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_top_factor_features.R
\name{extract_top_factor_features}
\alias{extract_top_factor_features}
\title{Extract Top Contributing Features for Factors}
\usage{
extract_top_factor_features(
  exposomicset,
  factors = NULL,
  pval_col = "p_adjust",
  pval_thresh = 0.05,
  method = "percentile",
  percentile = 0.9,
  threshold = 0.3,
  action = "add"
)
}
\arguments{
\item{exposomicset}{A \code{MultiAssayExperiment} object containing
integration results.}

\item{factors}{A character vector specifying the factors of interest.
If \code{NULL}, factors are automatically selected from the association results
using the \code{pval_col} and \code{pval_thresh} criteria.}

\item{pval_col}{A string specifying the column name of the p-value or
adjusted p-value used for factor selection if \code{factors} is \code{NULL}.
Default is \code{"p_adjust"}.}

\item{pval_thresh}{A numeric value specifying the significance threshold
for selecting factors from association results when \code{factors} is \code{NULL}.
Default is \code{0.05}.}

\item{method}{A character string specifying the feature selection method
(\code{"percentile"} or \code{"threshold"}). Default is \code{"percentile"}.}

\item{percentile}{A numeric value between 0 and 1 indicating the
percentile threshold for feature selection when \code{method = "percentile"}.
Default is \code{0.9}.}

\item{threshold}{A numeric value specifying the absolute loading cutoff
for feature selection when \code{method = "threshold"}. Default is \code{0.3}.}

\item{action}{A character string indicating whether to return results
(\code{"get"}) or add them to metadata (\code{"add"}). Default is \code{"add"}.}
}
\value{
If \code{action = "add"}, returns the modified \code{exposomicset} with
selected features stored in metadata.
If \code{action = "get"}, returns a data frame containing:
\item{feature}{The selected feature contributing to the factor.}
\item{factor}{The factor to which the feature contributes.}
\item{loading}{The factor loading value of the feature.}
\item{exp_name}{The experiment from which the feature originated.}
}
\description{
Identifies the most influential features for specified factors
using multiomics integration results.
Features are selected based on either a percentile cutoff
or an absolute loading threshold.
}
\details{
The function extracts factor loadings from \code{metadata(exposomicset)},
applies filtering based on
the selected method, and identifies top contributing features for
each specified factor.

If \code{factors} is not provided, the function will automatically select
statistically significant factors from \code{metadata(exposomicset)$association$assoc_factors$results_df}
using the specified \code{pval_col} and \code{pval_thresh} as criteria.

Features can be selected using:
\itemize{
\item \strong{Percentile-based filtering} (\code{method = "percentile"}): Selects
features with absolute loadings above a specified percentile.
\item \strong{Threshold-based filtering} (\code{method = "threshold"}): Selects
features with absolute loadings exceeding a fixed value.
}
}
\examples{
# create example data
mae <- make_example_data(
    n_samples = 20,
    return_mae = TRUE
)

# perform multiomics integration
mae <- run_multiomics_integration(
    mae,
    method = "DIABLO",
    outcome = "smoker",
    n_factors = 3
)

top_feats <- extract_top_factor_features(
    mae,
    factors = c("V1", "V2", "V3"),
    method = "percentile",
    percentile = 0.9,
    action = "get"
)

}
