% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_results_excel.R
\name{extract_results_excel}
\alias{extract_results_excel}
\title{Export tidyexposomics Results to Excel}
\usage{
extract_results_excel(
  exposomicset,
  file = "tidyexposomics_results.xlsx",
  result_types = c("correlation", "association", "differential_analysis",
    "multiomics_integration", "network", "enrichment", "exposure_summary", "pipeline"),
  include_empty_tabs = FALSE
)
}
\arguments{
\item{exposomicset}{A \code{MultiAssayExperiment} object with results stored
in \verb{@metadata}, typically created by the \code{tidyexposomics} pipeline.}

\item{file}{Character. Path to the output Excel file.}

\item{result_types}{Character vector specifying which result categories
to export. Options include:
\itemize{
\item \code{"correlation"}: Correlation results.
\item \code{"association"}: Association results.
\item \code{"differential_analysis"}: Differential abundance results,
including sensitivity analysis if available.
\item \code{"multiomics_integration"}: Common top features contributing to
latent factors from multi-omics integration.
\item \code{"network"}: Exposure impact metrics from network analyses.
\item \code{"enrichment"}: Enrichment results by omic and exposure category.
\item \code{"exposure_summary"}: Summary statistics for exposure variables.
\item \code{"pipeline"}: Overview of steps completed in the pipeline.
}

Use \code{"all"} to export all of the above categories.}

\item{include_empty_tabs}{Logical. If \code{TRUE}, adds placeholder sheets for
any missing result types. Default is \code{FALSE}.}
}
\value{
An Excel file is written to the specified path.
A message is printed with the file location.
}
\description{
Exports selected results stored in a \code{MultiAssayExperiment} object created
by the \code{tidyexposomics} pipeline to an Excel workbook.
Users can select which result types to include,
and optionally add placeholder sheets for missing data.
}
\examples{
# Create example data
mae <- make_example_data(
    n_samples = 20,
    return_mae = TRUE
)

# run correlation analysis
mae <- mae |>
    run_correlation(
        feature_type = "exposures",
        exposure_cols = c("exposure_pm25", "exposure_no2", "age", "bmi")
    )

# file path of the output file
tmp <- tempfile(fileext = ".xlsx")

# extract the correlation results
extract_results_excel(
    exposomicset = mae,
    result_types = "correlation",
    file = tmp
)

}
