% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keep_identify_abundant.R
\docType{methods}
\name{keep_abundant,SummarizedExperiment-method}
\alias{keep_abundant,SummarizedExperiment-method}
\title{keep_abundant}
\usage{
\S4method{keep_abundant}{SummarizedExperiment}(
  .data,
  abundance = assayNames(.data)[1],
  design = NULL,
  formula_design = NULL,
  minimum_counts = 10,
  minimum_proportion = 0.7,
  minimum_count_per_million = NULL,
  factor_of_interest = NULL,
  ...,
  .abundance = NULL
)
}
\arguments{
\item{.data}{A `tbl` or `SummarizedExperiment` object containing transcript/gene abundance data}

\item{abundance, .abundance}{The name of the transcript/gene abundance column (character, preferred)}

\item{design}{A design matrix for more complex experimental designs. If provided, this is passed to filterByExpr instead of factor_of_interest.}

\item{formula_design}{A formula for creating the design matrix}

\item{minimum_counts}{The minimum count threshold for a feature to be considered abundant}

\item{minimum_proportion}{The minimum proportion of samples in which a feature must be abundant}

\item{minimum_count_per_million}{The minimum count per million threshold}

\item{factor_of_interest}{The name of the column containing groups/conditions for filtering. DEPRECATED: Use 'design' or 'formula_design' instead.}

\item{...}{Further arguments.}
}
\value{
A `SummarizedExperiment` object
}
\description{
keep_abundant
}
