% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_verbs.R
\name{ungroup.flowSet}
\alias{ungroup.flowSet}
\title{Ungroup a flowSet}
\usage{
\method{ungroup}{flowSet}(x, ...)
}
\arguments{
\item{x}{A \code{\link[flowCore]{flowSet}}}

\item{...}{Variables/columns in \code{\link[Biobase]{pData}} to remove
from the grouping. Note that the "name" field in a flowSet's pData is special
in flowCore, so requesting an ungrouping by name will result in a copied
column called ".tidyFlowCore_name" in the result.
Also note that the column ".tidytof_unique_identifier" is used internally
and will not have any effect on the ungrouping.}
}
\value{
A \code{\link[flowCore]{flowFrame}} or
\code{\link[flowCore]{flowSet}} depending on the degree of ungrouping.
Note that unnest-ing and ungrouping a \code{\link[flowCore]{flowSet}} are
equivalent.
}
\description{
Ungroup a flowSet
}
\examples{
my_flowset <- simulate_cytometry_data()$flowset

my_flowset |>
  dplyr::ungroup()


}
