% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_verbs.R
\name{rename_with.flowSet}
\alias{rename_with.flowSet}
\title{Rename columns in a \code{\link[flowCore]{flowSet}}}
\usage{
\method{rename_with}{flowSet}(.data, .fn, .cols = dplyr::everything(), ...)
}
\arguments{
\item{.data}{A \code{\link[flowCore]{flowSet}}}

\item{.fn}{A function used to transform the selected .cols. Should return a character vector the same length as the input.}

\item{.cols}{Unquoted column names indicating which columns to rename (as specified by the \code{\link[flowCore]{featureNames}} of
the \code{\link[flowCore]{flowFrame}}s making up the \code{\link[flowCore]{flowSet}}).}

\item{...}{Additional arguments passed onto .fn.}
}
\value{
An object of the same type as .data. The output has the following properties:
* Rows are not affected.
* Column names are changed; column order is preserved.
* The \code{\link[flowCore]{flowSet}}'s \code{\link[Biobase]{pData}} will be preserved.
}
\description{
Rename columns in a \code{\link[flowCore]{flowSet}}
}
\examples{
my_flowset <- simulate_cytometry_data()$flowset

my_flowset |>
  dplyr::rename_with(.fn = toupper)


}
