% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_verbs.R
\name{rename.flowSet}
\alias{rename.flowSet}
\title{Rename columns in a \code{\link[flowCore]{flowSet}}}
\usage{
\method{rename}{flowSet}(.data, ...)
}
\arguments{
\item{.data}{A \code{\link[flowCore]{flowSet}}}

\item{...}{Unquoted name-value pairs (as specified by the \code{\link[flowCore]{featureNames}} of
the \code{\link[flowCore]{flowFrame}}s making up the \code{\link[flowCore]{flowSet}}).
Use new_name = old_name to rename selected columns}
}
\value{
An object of the same type as .data. The output has the following properties:
* Rows are not affected.
* Column names are changed; column order is preserved.
* The \code{\link[flowCore]{flowSet}}'s \code{\link[Biobase]{pData}} will be preserved.
}
\description{
Rename columns in a \code{\link[flowCore]{flowSet}}
}
\examples{
my_flowset <- simulate_cytometry_data()$flowset

my_flowset |>
  dplyr::rename(new_feature = feature_1)


}
