% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terraTCGAdata.R
\name{getTCGAdatalist}
\alias{getTCGAdatalist}
\title{Import Terra TCGA data as a list}
\usage{
getTCGAdatalist(
  assayNames,
  sampleCode,
  workspace = terraTCGAworkspace(),
  namespace = .DEFAULT_NAMESPACE,
  tablename = .DEFAULT_TABLENAME,
  sampleIdx = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{assayNames}{character() A vector of assays selected from the colnames
of \code{getAssayTable}.}

\item{sampleCode}{character(1) The sample code used to filtering samples
e.g., "01" for Primary Solid Tumors, see
\code{data("sampleTypes", package = "TCGAutils")} for reference}

\item{workspace}{character(1) The Terra Data Resources workspace from which
to pull TCGA data (default: see \code{terraTCGAworkspace()}). This is set to a
package-wide option.}

\item{namespace}{character(1) The Terra Workspace Namespace that
defaults to "broad-firecloud-tcga" and rarely needs to be changed.}

\item{tablename}{The Terra data model table from which to extract the
clinical data (default: "sample")}

\item{sampleIdx}{numeric() index or TRUE. Specify an index for subsetting the
assay data. This argument is mainly used for example and vignette
purposes. To use all the data, use the default value (default: \code{TRUE})}

\item{verbose}{logical(1L) Whether to output additional details of the
data facilitation.}
}
\value{
A \code{list} of assay datasets
}
\description{
Import Terra TCGA data as a list
}
\examples{
if (
    GCPtools::gcloud_exists() &&
    identical(AnVILBase::avplatform_namespace(), "AnVILGCP") &&
    nzchar(AnVILGCP::avworkspace_name())
)
  getTCGAdatalist(
      assayNames = c("protein_exp__mda_rppa_core__mdanderson_org__Level_3__protein_normalization__data",
      "snp__genome_wide_snp_6__broad_mit_edu__Level_3__segmented_scna_minus_germline_cnv_hg18__seg"),
      sampleCode = c("01", "10"),
      workspace = "TCGA_COAD_OpenAccess_V1-0_DATA"
  )

}
