% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/countsToProps.R
\name{countsToProps}
\alias{countsToProps}
\alias{countsToProps,GRangesList-method}
\title{Convert allele counts to proportions}
\usage{
countsToProps(counts)

\S4method{countsToProps}{GRangesList}(counts)
}
\arguments{
\item{counts}{\code{GRangesList} containing a summary of allele counts at each
range.
Each element of the list represents a distinct sample group.}
}
\value{
\code{GRangesList} containing a summary of normalised allele counts
(i.e. as proportions) at each range.
Each element of the list represents a distinct sample group.
}
\description{
Normalise allele-level counts across samples by converting to a
proportion of total alleles in all samples.
}
\examples{
fl <- system.file("extdata", "chr1.vcf.bgz", package="tadar")
genotypes <- readGenotypes(fl)
groups <- list(
    group1 = paste0("sample", 1:6),
    group2 = paste0("sample", 7:13)
)
counts <- countAlleles(genotypes, groups)
counts_filt <- filterLoci(counts)
countsToProps(counts_filt)

}
