% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/volcanoplot.R
\name{volcanoplot}
\alias{volcanoplot}
\title{Volcano plot with \code{volcanoplot}}
\usage{
volcanoplot(
  degseqDF,
  comparison,
  filter = c(Fold = 2, FDR = 10),
  genes = "NULL",
  plotly = FALSE,
  savePlot = FALSE,
  filePlot = NULL
)
}
\arguments{
\item{degseqDF}{object of class \code{data.frame} generated by
\code{\link[systemPipeR:run_edgeR]{systemPipeR::run_edgeR()}} or \code{\link[systemPipeR:run_DESeq2]{systemPipeR::run_DESeq2()}}.}

\item{comparison}{\verb{character vector} specifying the factor names for
comparison.}

\item{filter}{Named vector with filter cutoffs of format c(Fold=2, FDR=1)
where Fold refers to the fold change cutoff (unlogged) and FDR to the
p-value cutoff.}

\item{genes}{\verb{character vector} of genes names to show on the plot.}

\item{plotly}{logical: when \code{FALSE} (default), the \code{ggplot2} plot will be
returned.
\code{TRUE} option returns the \code{plotly} version of the plot.}

\item{savePlot}{logical: when \code{FALSE} (default), the plot will not be saved.
If \code{TRUE} the plot will be saved, and requires the \code{filePlot} argument.}

\item{filePlot}{file name where the plot will be saved. For more information,
please consult the \code{\link[ggplot2:ggsave]{ggplot2::ggsave()}} function.}
}
\value{
returns an object of \code{ggplot} or \code{plotly} class.
}
\description{
A simple function that shows statistical significance
(\code{p-value}) versus magnitude of change (\verb{log2 fold change}).
}
\examples{
## Load targets file and count reads dataframe
targetspath <- system.file("extdata", "targets.txt", package = "systemPipeR")
targets <- read.delim(targetspath, comment = "#")
cmp <- systemPipeR::readComp(
    file = targetspath, format = "matrix",
    delim = "-"
)
countMatrixPath <- system.file("extdata", "countDFeByg.xls",
    package = "systemPipeR"
)
countMatrix <- read.delim(countMatrixPath, row.names = 1)
### DEG analysis with `systemPipeR`
degseqDF <- systemPipeR::run_DESeq2(
    countDF = countMatrix,
    targets = targets, cmp = cmp[[1]], independent = FALSE)
DEG_list <- systemPipeR::filterDEGs(
    degDF = degseqDF,
    filter = c(Fold = 2, FDR = 10))
## Plot
volcanoplot(degseqDF,
    comparison = "M12-A12", filter = c(Fold = 1, FDR = 20),
    genes = "ATCG00280")
}
