% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exploreDDS.R
\name{exploreDDS}
\alias{exploreDDS}
\title{exploreDDS}
\usage{
exploreDDS(
  countMatrix,
  targets,
  cmp = cmp[[1]],
  preFilter = NULL,
  transformationMethod = "raw",
  blind = TRUE
)
}
\arguments{
\item{countMatrix}{\code{date.frame} or \code{matrix} containing raw read counts.}

\item{targets}{targets \code{data.frame}.}

\item{cmp}{\verb{character matrix} where comparisons are defined in two columns.
This matrix should be generated with the \code{\link[systemPipeR:readComp]{systemPipeR::readComp()}} function
from the targets file. Values used for comparisons need to match those in the
\code{Factor} column of the targets file.}

\item{preFilter}{allows removing rows in which there are very few reads.
Accepts a numeric value with the minimum of total reads to keep. Default is
\code{NULL}.}

\item{transformationMethod}{a \verb{character string} indicating which
transformation method it will be used on the raw read counts. Supported
methods include \code{rlog} and \code{vst} using the \code{DESeq2} package or default \code{raw}
for no data transformation.}

\item{blind}{logical, whether to blind the transformation to the experimental
design (see varianceStabilizingTransformation),
from \code{\link[DESeq2:vst]{DESeq2::vst()}} or \code{\link[DESeq2:rlog]{DESeq2::rlog()}}.}
}
\value{
returns an object of class \code{\link[DESeq2:DESeqTransform]{DESeq2::DESeqTransform()}}.
}
\description{
Convenience wrapper function to transform raw read counts using
the \code{\link[DESeq2:DESeq2-package]{DESeq2::DESeq2-package()}} package transformations methods. The input
file has to contain all the genes, not just differentially expressed ones.
}
\details{
Note that the recommendation is to use the resulting transformed
values in the \code{transformationMethod} argument only for visualization and
clustering, not for differential expression analysis which needs raw counts.
Users are strongly encouraged to consult the \code{\link[DESeq2:DESeq2-package]{DESeq2::DESeq2-package()}}
vignette for
more detailed information on this topic and how to properly run \code{DESeq2} on
data sets with more complex experimental designs.
}
\examples{
## Targets file
targetspath <- system.file("extdata", "targets.txt", package = "systemPipeR")
targets <- read.delim(targetspath, comment = "#")
cmp <- systemPipeR::readComp(file = targetspath, format = "matrix", 
delim = "-")
## Count table file
countMatrixPath <- system.file("extdata", "countDFeByg.xls", 
package = "systemPipeR")
countMatrix <- read.delim(countMatrixPath, row.names = 1)
## Run
exploredds <- exploreDDS(countMatrix, targets,
    cmp = cmp[[1]],
    preFilter = NULL, transformationMethod = "raw"
)
exploredds
}
\references{
For more details on \code{DESeq2}, please consult the following
page:
\href{http://bioconductor.org/packages/release/bioc/html/DESeq2.html}{DESeq2}.
For more details on \code{targets} file definition, please consult the following
page:
\href{http://www.bioconductor.org/packages/release/bioc/vignettes/systemPipeR/inst/doc/systemPipeR.html#25_structure_of_targets_file}{systemPipeR}.
}
\author{
Daniela Cassol
}
