% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spsUIcollections.R
\name{genGallery}
\alias{genGallery}
\title{Generate gallery by only providing tab names}
\usage{
genGallery(
  tab_ids = NULL,
  Id = NULL,
  title = "Gallery",
  type = NULL,
  title_color = "#0275d8",
  image_frame_size = 3,
  app_path = NULL
)
}
\arguments{
\item{tab_ids}{a vector of tab IDs}

\item{Id}{element ID}

\item{title}{gallery title}

\item{type}{If this value is not \code{NULL}, filter by tab type, and tab_ids
will be ignored. One of c("core", "wf", "data", "vs"). use \code{\link[=spsTabInfo]{spsTabInfo()}}
to see tab information}

\item{title_color}{title color, common colors or hex code}

\item{image_frame_size}{integer, 1-12}

\item{app_path}{app path, default current working directory}
}
\value{
gallery div
}
\description{
A fast way in SPS to generate a gallery to display plot tab
screenshots
}
\details{
require a SPS project and the config/tabs.csv file. If you want to
use gallery outside a SPS project, use \link[spsComps:gallery]{spsComps::gallery}
}
\examples{
if(interactive()){
    spsInit()
    ui <- fluidPage(
        genGallery(c("plot_example1")),
        genGallery(type = "plot")
    )
    server <- function(input, output, session) {

    }
    shinyApp(ui, server)
}
}
