% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_similarity_searches.R
\name{run_last}
\alias{run_last}
\title{Wrapper to run last from an R session}
\usage{
run_last(
  seq = NULL,
  verbose = FALSE,
  outdir = tempdir(),
  threads = 1,
  compare = "all",
  lastD = 1e+06,
  ...
)
}
\arguments{
\item{seq}{A processed list of AAStringSet objects
as returned by \code{process_input()}.}

\item{verbose}{Logical indicating if progress messages should be printed.
Default: FALSE.}

\item{outdir}{Output directory for last results. By default, output files
are saved to a temporary directory.}

\item{threads}{Number of threads to use. Default: 1.}

\item{compare}{Character scalar indicating which comparisons
should be made when running last.
Possible modes are "all" (all-vs-all comparisons),
"intraspecies" (intraspecies comparisons only), or
"interspecies" (interspecies comparisons only). Alternatively, users can
pass a 2-column data frame as input with the names of species to be
compared.}

\item{lastD}{last option D: query letters per random alignment. Default: 1e6.}

\item{...}{Any additional arguments to \code{lastal}.}
}
\value{
A list of data frames containing last's tabular output
for each pairwise combination of species. For n species, the list length
will be \eqn{n^2}.
}
\description{
Wrapper to run last from an R session
}
\examples{
data(proteomes)
data(annotation)
seq <- process_input(proteomes, annotation)$seq[1:2]
if(last_is_installed()) {
    last_results <- run_last(seq)
}
}
