% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_similarity_searches.R
\name{run_diamond}
\alias{run_diamond}
\title{Wrapper to run DIAMOND from an R session}
\usage{
run_diamond(
  seq = NULL,
  top_hits = 5,
  verbose = FALSE,
  outdir = tempdir(),
  threads = NULL,
  compare = "all",
  ...
)
}
\arguments{
\item{seq}{A processed list of AAStringSet objects
as returned by \code{process_input()}.}

\item{top_hits}{Number of top hits to keep in DIAMOND search. Default: 5.}

\item{verbose}{Logical indicating if progress messages should be printed.
Default: FALSE.}

\item{outdir}{Output directory for DIAMOND results. By default, output files
are saved to a temporary directory.}

\item{threads}{Number of threads to use. Default: let DIAMOND auto-detect
and use all available virtual cores on the machine.}

\item{compare}{Character scalar indicating which comparisons
should be made when running DIAMOND.
Possible modes are "all" (all-vs-all comparisons),
"intraspecies" (intraspecies comparisons only), or
"interspecies" (interspecies comparisons only). Alternatively, users can
pass a 2-column data frame as input with the names of species to be
compared.}

\item{...}{Any additional arguments to \verb{diamond blastp}.}
}
\value{
A list of data frames containing DIAMOND's tabular output
for each pairwise combination of species. For n species, the list length
will be \eqn{n^2}.
}
\description{
Wrapper to run DIAMOND from an R session
}
\examples{
data(proteomes)
data(annotation)
seq <- process_input(proteomes, annotation)$seq[1:2]
if(diamond_is_installed()) {
    diamond_results <- run_diamond(seq)
}
}
