% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_multi_drugs.R
\name{.ExtractMultiDrugPlotData}
\alias{.ExtractMultiDrugPlotData}
\title{Extract Data Table and Annotation Information for Multi-drug Plotting}
\usage{
.ExtractMultiDrugPlotData(
  data,
  plot_block = 1,
  plot_value = "response",
  summary_statistic = NULL,
  statistic = NULL,
  titles = TRUE
)
}
\arguments{
\item{data}{A list object generated by function \code{\link{ReshapeData}}.}

\item{plot_block}{A character/integer. It indicates the block ID for the
block to visualize.}

\item{plot_value}{A vector of characters. It contains the name of one or more
metrics to be visualized. If the \code{data} is the direct output from 
\link{ReshapeData}, the values for this parameter are:
\itemize{
  \item \strong{response_origin} The original response value in input data.
  It might be \% inhibition or \% viability.
  \item \strong{response} The \% inhibition after preprocess by function 
  \link{ReshapeData}
}
If the \code{data} is the output from \link{CalculateSynergy}, following
values are also available:
\itemize{
  \item \strong{ZIP_ref, Bliss_ref, HSA_ref, Loewe_ref} The reference
  additive effects calculated by ZIP, Bliss, HSA or Loewe model,
  respectively.
  \item \strong{ZIP_synergy, Bliss_synergy, HSA_synergy, Loewe_synergy}
  The synergy score calculated by ZIP, Bliss, HSA or Loewe model,
  respectively.
  \item \strong{ZIP_fit} The response fitted by ZIP model.
}}

\item{summary_statistic}{A vector of characters or NULL. It indicates the
summary statistics for all the \code{plot_value} in whole combination
matrix. Available values are:
\itemize{
  \item \strong{mean} Median value for all the responses or synergy
  scores in the matrix and the p-value if it is valid;
  \item \strong{median} Median value for all the responses or synergy
  scores in the matrix;
  \item \strong{quantile_90} 90\% quantile. User could change the number to
  print different sample quantile. For example quantile_50 equal to median. 
}
If it is \code{NULL}, no statistics will be printed.}

\item{statistic}{A character or NULL. It indicates the statistics printed
in the plot while there are replicates in input data. Available values are:
\itemize{
  \item \strong{sem} Standard error of mean;
  \item \strong{ci} 95% confidence interval.
}
If it is \code{NULL}, no statistics will be printed.}

\item{titles}{A logical value. If it is \code{TRUE}, the plot tile, subtilte,
and title for z axis will be extracted and output.}
}
\value{
A list. It contains the elements:
  \itemize{
    \item \strong{plot_table} A data frame contains concentrations for all
      drugs, the values for \code{plot_value}.
    \item \strong{drug_pair} A data frame contains the drug names and
      concentration unites, whither the block is replicate or not.
    \item \strong{plot_subtitle} A string for plot subtitle.
    \item \strong{plot_title} A string for plot title.
    \item \strong{z_axis_subtitle} A string for plot z-axis title.
  }
}
\description{
This function extracts the information for Multi-drug plotting from input
list \code{data}. It is an auxiliary function for \link{PlotMultiDrugSurface}
and \link{PlotMultiDrugBar}.
}
\author{
\itemize{
  \item Shuyu Zheng \email{shuyu.zheng@helsinki.fi}
  \item Jing Tang \email{jing.tang@helsinki.fi}
}
}
