% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_sensitivity_synergy.R
\name{PlotSensitivitySynergy}
\alias{PlotSensitivitySynergy}
\title{Plot Sensitive-Synergy Plot for All the Combinations in the Input Data}
\usage{
PlotSensitivitySynergy(
  data,
  plot_synergy,
  point_size = 1,
  point_color = "#2D72AD",
  show_labels = FALSE,
  point_label_color = "#2D72AD",
  label_size = 10,
  dynamic = FALSE,
  plot_title = NULL,
  axis_line = FALSE,
  text_size_scale = 1
)
}
\arguments{
\item{data}{A list object has been processed by functions:
\code{\link{ReshapeData}}, \code{\link{CalculateSynergy}}, and 
\code{\link{CalculateSensitivity}}.}

\item{plot_synergy}{A character value. It indicates the synergy score for
visualization. The available values are: "ZIP", "HSA", Bliss", "Leowe".}

\item{point_size}{A numeric value. It indicates the size of points. The unit
is "mm"}

\item{point_color}{An R color value. It indicates the color for the points.}

\item{show_labels}{A logic value. It indicates whether to show the labels
along with points or not.}

\item{point_label_color}{An R color value. It indicates the color for the
label of data points.}

\item{label_size}{A numeric value. It controls the size of the labels in "pt"}

\item{dynamic}{A logical value. If it is \code{TRUE}, this function will
use \link[plotly]{plot_ly} to generate an interactive plot. If it is
\code{FALSE}, this function will use \link[lattice]{wireframe} to generate
a static plot.}

\item{plot_title}{A character value. It specifies the plot title. If it is
\code{NULL}, the function will automatically generate a title.}

\item{axis_line}{A logical value. Whether to show the axis lines and ticks.}

\item{text_size_scale}{A numeric value. It is used to control the size
of text for axis in the plot. All the text size will multiply by this
scale factor.}
}
\value{
A ggplot object, while \code{dynamic = FALSE}. A plotly object,
  while \code{dynamic = TRUE}.
}
\description{
This function will generate a scatter plot for all the combinations in the
input data. The x-axis is the Combination Sensitive score (CSS).
}
\examples{
data("mathews_screening_data")
data <- ReshapeData(mathews_screening_data)
data <- CalculateSynergy(data, method = c("ZIP"))
data <- CalculateSensitivity(data)
PlotSensitivitySynergy(data, plot_synergy = "ZIP")
}
\author{
\itemize{
  \item Shuyu Zheng \email{shuyu.zheng@helsinki.fi}
  \item Jing Tang \email{jing.tang@helsinki.fi}
}
}
