% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_sensitivity_score.R
\name{CalculateSensitivity}
\alias{CalculateSensitivity}
\title{Calculate the Sensitivity Scores for Drug Combinations}
\usage{
CalculateSensitivity(
  data,
  adjusted = TRUE,
  correct_baseline = "non",
  iteration = 10,
  seed = 123
)
}
\arguments{
\item{data}{A list object generated by function \code{\link{ReshapeData}}.}

\item{adjusted}{A logical value. If it is \code{TRUE}, the
'adjusted.response.mats' will be used to calculate synergy scores. If it is
\code{FALSE}, the raw data ('dose.response.mats') will be used to calculate
synergy scores.}

\item{correct_baseline}{A character value. It indicates the method used for
baseline correction. Available values are:
\itemize{
  \item \strong{non} No baseline correction.
  \item \strong{part} Adjust only the negative values in the matrix.
  \item \strong{all} Adjust all values in the matrix.
}}

\item{iteration}{An integer. It indicates the number of iterations for
bootstrap on data with replicates.}

\item{seed}{An integer or NULL. It is used to set the random seed in synergy
scores calculation on data with replicates.}
}
\value{
This function will add columns into \code{data$drug_pairs} table.
  The columns are:
  \itemize{
    \item \strong{ic50_1/2/...} Relative IC50 for drug 1, 2, ...
    \item \strong{ri_1/2/...} Relative Inhibition (RI) for drug 1, 2, ...
    \item \strong{css1_ic502/...} CSS score of drug 1 while fixing drug 2
      at its IC50.
    \item \strong{css} Over all CSS score for the whole block. It's the mean
      value of the CSS for all drug pairs in the combination. 
 }
 If there are replicates in the block, this function will add one table named
 as "sensitivity_scores_statistics" for the statistics of the values
 mentioned about into the input \code{data} list.
}
\description{
\code{CalculateSensitivity} is the main function for calculating sensitivity
scores from the dose response matrix. It will return the RI
(relative inhibition), IC50 (relative IC50) for each drug in the combination.
It will also calculate the CSS (combination sensitivity score) for each drug
while other drugs are at their IC50 and the CSS for the whole combination
matrix.
}
\examples{
data("ONEIL_screening_data")
data <- ReshapeData(ONEIL_screening_data, data_type = "inhibition")
data <- CalculateSensitivity(data)
}
\author{
\itemize{
  \item Shuyu Zheng \email{shuyu.zheng@helsinki.fi}
  \item Jing Tang \email{jing.tang@helsinki.fi}
}
}
