% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/switchde.R
\name{switchde}
\alias{switchde}
\title{Switch-like model fitting and differential expression test}
\usage{
switchde(object, pseudotime = NULL, zero_inflated = FALSE,
  lower_threshold = 0.01, maxiter = 1000, log_lik_tol = 0.01,
  verbose = FALSE, sce_assay = "exprs")
}
\arguments{
\item{object}{Gene expression data that is either
\itemize{
 \item A vector of length number of cells for a single gene
 \item A matrix of dimension number of genes x number of cells
 \item An object of class \code{SingleCellExperiment} from package SingleCellExperiment
 }}

\item{pseudotime}{A pseudotime vector with a pseudotime corresponding to 
every cell. Can be \code{NULL} if object is of class \code{SCESet} and 
\code{colData(sce)$pseudotime} is defined.}

\item{zero_inflated}{Logical. Should zero inflation be implemented? Default  \code{FALSE}}

\item{lower_threshold}{The minimum threshold below which to set expression to zero to avoid
numerical issues. Default is 0.01}

\item{maxiter}{Maximum number of iterations for EM algorithm if zero inflation enabled. Default 100}

\item{log_lik_tol}{If the change in the log-likelihood falls below this for zero inflated EM
the algorithm is assumed to have converged}

\item{verbose}{Print convergence update for EM algorithm}

\item{sce_assay}{The assay from the \code{SingleCellExperiment} to be used
as expression, defaulting to "exprs"}
}
\value{
A matrix where each column corresponds to a gene, the first row is
the p-value for that gene and subsequent rows are model parameters.
}
\description{
Fit sigmoidal differential expression models to gene expression across pseudotime.
Parameter estimates are returned along with a p-value for switch-like differential
expression over a null model (constant expression).
}
\examples{
data(synth_gex)
data(ex_pseudotime)
sde <- switchde(synth_gex, ex_pseudotime)
}
