% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm_qvalue.R
\name{lm_qvalue}
\alias{lm_qvalue}
\title{Estimation of qvalues conditioned on covariates}
\usage{
lm_qvalue(
  p,
  X,
  pfdr = FALSE,
  pi0 = NULL,
  smoothing = c("unit.spline", "smooth.spline"),
  ...
)
}
\arguments{
\item{p}{numeric vector of p-values}

\item{X}{matrix of covariates (can be missing if pi0 is specified instead)}

\item{pfdr}{logical, making estimates robust for small p-values and a small
sample size}

\item{pi0}{list with pi0 estimates from lm_pi0. If this is not provided,
pi0 is estimated using function lm_pi0.}

\item{smoothing}{character, type of smoothing used to fit pi0. Note the
default in this function is different than in lm_pi0.}

\item{...}{other parameters (passed on to lm_pi0 if pi0 is not provided)}
}
\value{
object of class `lm_qvalue', which is a list with several components
\item{call}{matched function call}
\item{pvalues}{numeric vector of original p-values}
\item{qvalues}{numeric vector of q-values}
\item{}{other list elements transferred from pi0}
}
\description{
The recipe for turning pvalues into qvalues is adapted from package
'qvalue' and articles by Storey, Tibshirani, Taylor, Siegmund.
}
\examples{
# define a covariate
X <- rep(c(0, 1), each=1000)
# generate p-values, randomly for group 0 and with low values for group 1
pVal <- c(runif(1000), rbeta(1000, 0.2, 1))
# compute qvalues, using the covariate
qVal <- lm_qvalue(pVal, X=X)

}
