% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_class.R
\name{model}
\alias{model}
\alias{model_train,model,DatasetExperiment-method}
\alias{model_predict,model,DatasetExperiment-method}
\alias{model_apply,model,DatasetExperiment-method}
\alias{model_reverse,model,DatasetExperiment-method}
\alias{predicted,model-method}
\alias{seq_in,model-method}
\alias{seq_in<-,model,character-method}
\alias{predicted_name,model-method}
\alias{predicted_name<-,model,character-method}
\title{model class}
\usage{
model(
  predicted = character(0),
  seq_in = "data",
  seq_fcn = function(x) {
     return(x)
 },
  ...
)

\S4method{model_train}{model,DatasetExperiment}(M, D)

\S4method{model_predict}{model,DatasetExperiment}(M, D)

\S4method{model_apply}{model,DatasetExperiment}(M, D)

\S4method{model_reverse}{model,DatasetExperiment}(M, D)

\S4method{predicted}{model}(M)

\S4method{seq_in}{model}(M)

\S4method{seq_in}{model,character}(M) <- value

\S4method{predicted_name}{model}(M)

\S4method{predicted_name}{model,character}(M) <- value
}
\arguments{
\item{predicted}{The name of an output slot to return when using \code{predicted()} (see details)}

\item{seq_in}{the name of an output slot to connect with the "predicted" output
of another model (see details)}

\item{seq_fcn}{a function to apply to seq_in before inputting into the next model.
Typically used to extract a single column, or convert from factor to char etc.}

\item{...}{named slots and their values.}

\item{M}{A struct model object}

\item{D}{A DatasetExperiment object}

\item{value}{The value to assign}
}
\value{
trained model object

model object with test set results

trained model object

dataset dataset object with the reverse model applied

the predicted output, as specified by predicted_name

the id of the input parameter to be replaced by the \code{predicted}
output of the previous model in a model sequence. Reserved keyword 'data'
means that the input data used by \code{model_train}, \code{model_apply} etc is used.
\code{seq_in = 'data'} is the default setting.

the modified model object

the id of the output returned by predicted()

the modified model object
}
\description{
A class for models that can be trained/applied to datasets e.g. PCA, PLS etc.
Also used for preprocessing steps that require application to test sets.
not intended to be called directly, this class should be inherited to provide
functionality for method-specific classes.
}
\section{\code{predicted} slot}{

The "predicted" slot is a slots for use by users to control the flow of model
sequences. The \code{predicted()} function is used to return a default output and
from a model. Typically it is a DatasetExperiment object that is passed directly
into the next model in a sequence as the data for that model.
}

\section{\code{seq_in} slot}{

In a sequence of models (see model_seq) the "predicted" slot is connected to the
DatasetExperiment input of the next model. \code{seq_in} can be used to control
flow and connect the "predicted" output to the input parameter of the next model.
Default is the keyword 'data', and can otherwise be replaced by any input slot
from the model. The slot \code{seq_fcn} can be used to apply a transformation to
the output before it is used as an input. This allows you to e.g. convert between types,
extract a single column from a data.frame etc.
}

\examples{
M = model()
D = DatasetExperiment()
M = model()
M = model_train(M,D)
D = DatasetExperiment()
M = model()
M = model_train(M,D)
M = model_predict(M,D)
D = DatasetExperiment()
M = model()
M = model_apply(M,D)
D = DatasetExperiment()
M = model()
M = model_train(M,D)
M = model_predict(M,D)
M = model_reverse(M,D)
D = DatasetExperiment()
M = example_model()
M = model_train(M,D)
M = model_predict(M,D)
p = predicted(M)
D = DatasetExperiment()
M = example_model()
seq_in(M) = 'data'
M = example_model()
seq_in(M) = 'value_1'
M = example_model()
predicted_name(M)
M = example_model()
predicted_name(M) = 'result_2'
}
