% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/struct_class.R
\name{citations}
\alias{citations}
\alias{citations,struct_class-method}
\title{Citations for an object}
\usage{
citations(obj)

\S4method{citations}{struct_class}(obj)
}
\arguments{
\item{obj}{a struct object}
}
\value{
a character array of citations
}
\description{
All \code{struct} objects have a "citations" slot, which is a list of
references in bibtex format. The \code{citations} method gathers
citations from an object and all \code{struct} objects that it inherits to generate
a complete list.
}
\examples{
D = iris_DatasetExperiment()
D$citations # the list specifically defined for this object
citations(D) # the list for this object and all inherited ones
}
