% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ttest_class.R
\name{ttest}
\alias{ttest}
\title{t-test}
\usage{
ttest(
  alpha = 0.05,
  mtc = "fdr",
  factor_names,
  paired = FALSE,
  paired_factor = character(0),
  equal_variance = FALSE,
  conf_level = 0.95,
  control_group = NULL,
  ...
)
}
\arguments{
\item{alpha}{(numeric) The p-value cutoff for determining significance. The default is \code{0.05}.\cr}

\item{mtc}{(character) Multiple test correction method. Allowed values are limited to the following: \itemize{ \item{\code{"bonferroni"}: Bonferroni correction in which the p-values are multiplied by the number of comparisons.}\item{\code{"fdr"}: Benjamini and Hochberg False Discovery Rate correction.}\item{\code{"none"}: No correction.}} The default is \code{"fdr"}.}

\item{factor_names}{(character) The name of sample meta column(s) to use.}

\item{paired}{(logical) Apply a paired t-test. The default is \code{FALSE}.\cr}

\item{paired_factor}{(character) The factor name that encodes the sample id for pairing. The default is \code{character(0)}.}

\item{equal_variance}{(logical) Equal variance. Allowed values are limited to the following: \itemize{ \item{\code{"TRUE"}: The variance of each group is treated as being equal using the pooled variance to estimate the variance.}\item{\code{"FALSE"}: The variance of each group is not assumed to be equal and the Welch (or Satterthwaite) approximation is used.}} The default is \code{FALSE}.\cr}

\item{conf_level}{(numeric) The confidence level of the interval. The default is \code{0.95}.\cr}

\item{control_group}{(character, NULL) The level name of the group used as the second group (where possible) when computing t-statistics. This ensures a positive t-statistic corresponds to an increase when compared to the control group. The default is \code{NULL}.}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A  \code{ttest} object with the following \code{output} slots:
\tabular{ll}{
\code{t_statistic} \tab          (data.frame) The value of the calculate statistics which is converted to a p-value when compared to a t-distribution. \cr
\code{p_value} \tab          (data.frame) The probability of observing the calculated t-statistic. \cr
\code{dof} \tab          (numeric) The number of degrees of freedom used to calculate the test statistic. \cr
\code{significant} \tab          (data.frame) TRUE if the calculated p-value is less than the supplied threhold (alpha). \cr
\code{conf_int} \tab          (data.frame) Confidence interval for t statistic. \cr
\code{estimates} \tab          (data.frame) The group means estimated when computing the t-statistic. \cr
}
}
\description{
A t-test compares the means of two factor levels. Multiple-test corrected p-values are used to indicate the significance of the computed difference for all features.
}
\section{Inheritance}{

A \code{ttest} object inherits the following \code{struct} classes: \cr\cr
\verb{[ttest]} >> \verb{[model]} >> \verb{[struct_class]}
}

\examples{
M = ttest(
      alpha = 0.05,
      mtc = "fdr",
      factor_names = "V1",
      paired = FALSE,
      paired_factor = "NA",
      equal_variance = FALSE,
      conf_level = 0.95,
      control_group = NULL)

M = ttest(factor_name='Class')

}
