% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svm_classifier_class.R
\name{svm_plot_2d}
\alias{svm_plot_2d}
\title{SVM scatter plot}
\usage{
svm_plot_2d(factor_name, npoints = 100, ...)
}
\arguments{
\item{factor_name}{(character) The name of a sample-meta column to use.}

\item{npoints}{(numeric) The number of grid points used to plot the boundary. The default is \code{100}.\cr}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A  \code{
svm_plot_2d
} object. This object has no \code{output} slots.
See \code{\link[struct]{chart_plot}} in the \code{struct} package to plot this chart object.
}
\description{
A scatter plot of the input data by group and the calculated boundary of a SVM model.
}
\details{
This object makes use of functionality from the following packages:\itemize{  \item{\code{e1071}}}
}
\section{Inheritance}{

A \code{svm_plot_2d} object inherits the following \code{struct} classes: \cr\cr
\verb{[svm_plot_2d]} >> \verb{[chart]} >> \verb{[struct_class]}
}

\examples{
M = svm_plot_2d(
      factor_name = "V1",
      npoints = 100)

D = iris_DatasetExperiment()
M = filter_smeta(mode='exclude',levels='setosa',factor_name='Species') +
    mean_centre()+PCA(number_components=2)+
    SVM(factor_name='Species',kernel='linear')
M = model_apply(M,D)

C = svm_plot_2d(factor_name='Species')
chart_plot(C,M[4],predicted(M[3]))

}
\references{
Meyer D, Dimitriadou E, Hornik K, Weingessel A, Leisch F (2023).
\emph{e1071: Misc Functions of the Department of Statistics, Probability
Theory Group (Formerly: E1071), TU Wien}. R package version 1.7-14,
\url{https://CRAN.R-project.org/package=e1071}.
}
