% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLSDA_charts.R
\name{plsda_roc_plot}
\alias{plsda_roc_plot}
\title{PLSDA ROC plot}
\usage{
plsda_roc_plot(factor_name, ycol = 1, ...)
}
\arguments{
\item{factor_name}{(character) The name of a sample-meta column to use.}

\item{ycol}{(character, numeric, integer) The column of the Y block to be plotted. The default is \code{1}.\cr}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A  \code{
plsda_roc_plot
} object. This object has no \code{output} slots.
See \code{\link[struct]{chart_plot}} in the \code{struct} package to plot this chart object.
}
\description{
A Receiver Operator Characteristic (ROC) plot for PLSDA models computed by adjusting the threshold for assigning group labels from PLS predictions.
}
\details{
This object makes use of functionality from the following packages:\itemize{  \item{\code{pls}} \item{\code{ggplot2}}}
}
\section{Inheritance}{

A \code{plsda_roc_plot} object inherits the following \code{struct} classes: \cr\cr
\verb{[plsda_roc_plot]} >> \verb{[chart]} >> \verb{[struct_class]}
}

\examples{
M = plsda_roc_plot(
      factor_name = "V1",
      ycol = 1)

D = iris_DatasetExperiment()
M = mean_centre()+PLSDA(factor_name='Species')
M = model_apply(M,D)

C = plsda_roc_plot(factor_name='Species')
chart_plot(C,M[2])
}
\references{
Liland K, Mevik B, Wehrens R (2023). \emph{pls: Partial Least Squares and
Principal Component Regression}. R package version 2.8-3,
\url{https://CRAN.R-project.org/package=pls}.

Wickham H (2016). \emph{ggplot2: Elegant Graphics for Data Analysis}.
Springer-Verlag New York. ISBN 978-3-319-24277-4,
\url{https://ggplot2.tidyverse.org}.
}
