% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset_chart_classes.R
\name{mv_histogram}
\alias{mv_histogram}
\title{Missing value histogram}
\usage{
mv_histogram(label_outliers = TRUE, by_sample = TRUE, ...)
}
\arguments{
\item{label_outliers}{(logical) Label outliers. Allowed values are limited to the following: \itemize{ \item{\code{"TRUE"}: Sample labels for potential outliers are displayed on the plot.}\item{\code{"FALSE"}: Sample labels are not included on the plot.}} The default is \code{TRUE}.\cr}

\item{by_sample}{(logical) Plot by sample or by feature. Allowed values are limited to the following: \itemize{ \item{\code{"TRUE"}: Missing values are plotted per sample.}\item{\code{"FALSE"}: Missing values are plotted per feature.}} The default is \code{TRUE}.\cr}

\item{...}{additional slots and values passed to struct_class}
}
\value{
A  \code{
mv_histogram
} object. This object has no \code{output} slots.
See \code{\link[struct]{chart_plot}} in the \code{struct} package to plot this chart object.

struct object
}
\description{
A histogram of the numbers of missing values per sample/feature
}
\section{Inheritance}{

A \code{mv_histogram} object inherits the following \code{struct} classes: \cr\cr
\verb{[mv_histogram]} >> \verb{[chart]} >> \verb{[struct_class]}
}

\examples{
M = mv_histogram(
      label_outliers = FALSE,
      by_sample = FALSE)

D = MTBLS79_DatasetExperiment()
C = mv_histogram(label_outliers=FALSE,by_sample=FALSE)
chart_plot(C,D)

}
