% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_model_class.R
\name{linear_model}
\alias{linear_model}
\title{Linear model}
\usage{
linear_model(formula, na_action = "na.omit", contrasts = list(), ...)
}
\arguments{
\item{formula}{(formula) A symbolic description of the model to be fitted.}

\item{na_action}{(character) NA action. Allowed values are limited to the following: \itemize{ \item{\code{"na.omit"}: Incomplete cases are removed.}\item{\code{"na.fail"}: An error is thrown if NA are present.}\item{\code{"na.exclude"}: Incomplete cases are removed, and the output result is padded to the correct size using NA.}\item{\code{"na.pass"}: Does not apply a linear model if NA are present.}} The default is \code{"na.omit"}.}

\item{contrasts}{(list) The contrasts associated with a factor. The default is \code{list()}.}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A  \code{linear_model} object with the following \code{output} slots:
\tabular{ll}{
\code{lm} \tab          (lm) The lm object for this model_. \cr
\code{coefficients} \tab          (numeric) The coefficients for the fitted model_. \cr
\code{residuals} \tab          (numeric) The residuals for the fitted model_. \cr
\code{fitted_values} \tab          (numeric) The fitted values for the data used to train the model_. \cr
\code{predicted_values} \tab          (numeric) The predicted values for new data using the fitted model_. \cr
\code{r_squared} \tab          (numeric) The value of R Squared for the fitted model_. \cr
\code{adj_r_squared} \tab          (numeric) The value ofAdjusted  R Squared for the fitted model_. \cr
}
}
\description{
Linear models can be used to carry out regression, single stratum analysis of variance and analysis of covariance.
}
\details{
This object makes use of functionality from the following packages:\itemize{  \item{\code{stats}}}
}
\section{Inheritance}{

A \code{linear_model} object inherits the following \code{struct} classes: \cr\cr
\verb{[linear_model]} >> \verb{[model]} >> \verb{[struct_class]}
}

\examples{
M = linear_model(
      formula = y ~ x,
      na_action = "na.omit",
      contrasts = list())

D = iris_DatasetExperiment()
M = linear_model(formula = y~Species)

}
\references{
R Core Team (2024). \emph{R: A Language and Environment for Statistical
Computing}. R Foundation for Statistical Computing, Vienna, Austria.
\url{https://www.R-project.org/}.
}
