% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fisher_exact_class.R
\name{fisher_exact}
\alias{fisher_exact}
\title{Fisher Exact Test}
\usage{
fisher_exact(alpha = 0.05, mtc = "fdr", factor_name, factor_pred, ...)
}
\arguments{
\item{alpha}{(numeric) The p-value cutoff for determining significance. The default is \code{0.05}.\cr}

\item{mtc}{(character) Multiple test correction method. Allowed values are limited to the following: \itemize{ \item{\code{"bonferroni"}: Bonferroni correction in which the p-values are multiplied by the number of comparisons.}\item{\code{"fdr"}: Benjamini and Hochberg False Discovery Rate correction.}\item{\code{"none"}: No correction.}} The default is \code{"fdr"}.}

\item{factor_name}{(character) The name of a sample-meta column to use.}

\item{factor_pred}{(data.frame) A data.frame, where each column is a factor of predicted group labels to compare with the true groups labels.}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A  \code{fisher_exact} object with the following \code{output} slots:
\tabular{ll}{
\code{p_value} \tab          (data.frame) The probability of observing the calculated statistic if the null hypothesis is true. \cr
\code{significant} \tab          (data.frame) True/False indicating whether the p-value computed for each variable is less than the threshold. \cr
}
}
\description{
A fisher exact test is used to analyse contingency tables by comparing the number of correctly/incorrectly predicted group labels. A multiple test corrected p-value indicates whether the number of measured values is significantly different between groups.
}
\section{Inheritance}{

A \code{fisher_exact} object inherits the following \code{struct} classes: \cr\cr
\verb{[fisher_exact]} >> \verb{[model]} >> \verb{[struct_class]}
}

\examples{
M = fisher_exact(
      alpha = 0.05,
      mtc = "fdr",
      factor_name = "V1",
      factor_pred = data.frame(id=NA))

# load some data
D=MTBLS79_DatasetExperiment()

# prepare predictions based on NA
pred=as.data.frame(is.na(D$data))
pred=lapply(pred,factor,levels=c(TRUE,FALSE))
pred=as.data.frame(pred)

# apply method
M = fisher_exact(alpha=0.05,mtc='fdr',factor_name='Class',factor_pred=pred)
M=model_apply(M,D)
}
