% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svm_classifier_class.R
\name{SVM}
\alias{SVM}
\title{Support Vector Machine Classifier}
\usage{
SVM(
  factor_name,
  kernel = "linear",
  degree = 3,
  gamma = 1,
  coef0 = 0,
  cost = 1,
  class_weights = NULL,
  ...
)
}
\arguments{
\item{factor_name}{(character) The name of a sample-meta column to use.}

\item{kernel}{(character) Kernel type. Allowed values are limited to the following: \itemize{ \item{\code{"linear"}: .}\item{\code{"polynomial"}: .}\item{\code{"radial"}: .}\item{\code{"sigmoid"}: .}} The default is \code{"linear"}.}

\item{degree}{(numeric) The polynomial degree. The default is \code{3}.\cr}

\item{gamma}{(numeric) The gamma parameter. The default is \code{1}.\cr}

\item{coef0}{(numeric) The offset coefficient. The default is \code{0}.\cr}

\item{cost}{(numeric) The cost of violating the constraints. The default is \code{1}.\cr}

\item{class_weights}{(numeric, character, NULL) A named vector of weights for the different classes.  Specifying
"inverse" will choose the weights inversely proportional to the class distribution. The default is \code{NULL}.}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A  \code{SVM} object with the following \code{output} slots:
\tabular{ll}{
\code{SV} \tab          (matrix)  \cr
\code{index} \tab          (numeric)  \cr
\code{coefs} \tab          (matrix)  \cr
\code{pred} \tab          (data.frame)  \cr
\code{decision_values} \tab          (data.frame)  \cr
}

struct object
}
\description{
Support Vector Machines (SVM) are a machine learning algorithm for classification. They can make use of kernel functions to generate highly non-linear boundaries between groups.
}
\details{
This object makes use of functionality from the following packages:\itemize{  \item{\code{e1071}}}
}
\section{Inheritance}{

A \code{SVM} object inherits the following \code{struct} classes: \cr\cr
\verb{[SVM]} >> \verb{[model]} >> \verb{[struct_class]}
}

\examples{
M = SVM(
      factor_name = "V1",
      kernel = "linear",
      degree = 3,
      gamma = 1,
      coef0 = 0,
      cost = 1,
      class_weights = 1)

M = SVM(factor_name='Species',gamma=1)
}
\references{
Meyer D, Dimitriadou E, Hornik K, Weingessel A, Leisch F (2023).
\emph{e1071: Misc Functions of the Department of Statistics, Probability
Theory Group (Formerly: E1071), TU Wien}. R package version 1.7-14,
\url{https://CRAN.R-project.org/package=e1071}.

Brereton RG, Lloyd GR (2010). "Support Vector Machines for
classification and regression." \emph{The Analyst}, \emph{135}(2), 230-267.
}
