% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLSR_class.R
\name{PLSR}
\alias{PLSR}
\title{Partial least squares regression}
\usage{
PLSR(number_components = 2, factor_name, ...)
}
\arguments{
\item{number_components}{(numeric, integer) The number of PLS components. The default is \code{2}.\cr}

\item{factor_name}{(character) The name of sample meta column(s) to use.}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A  \code{PLSR} object with the following \code{output} slots:
\tabular{ll}{
\code{scores} \tab          (DatasetExperiment)  \cr
\code{loadings} \tab          (data.frame)  \cr
\code{yhat} \tab          (data.frame)  \cr
\code{y} \tab          (data.frame)  \cr
\code{reg_coeff} \tab          (data.frame)  \cr
\code{vip} \tab          (data.frame)  \cr
\code{pls_model} \tab          (list)  \cr
\code{pred} \tab          (data.frame)  \cr
\code{sr} \tab          (data.frame) Selectivity ratio for a variable represents a measure of a variable's importance in the PLS model. The output data.frame contains a column of selectivity ratios, a column of p-values based on an F-distribution and a column indicating significance at p < 0.05. \cr
\code{sr_pvalue} \tab          (data.frame) A p-value computed from the Selectivity Ratio based on an F-distribution. \cr
}
}
\description{
PLS is a multivariate regression technique that extracts latent variables maximising covariance between the input data and the response. For regression the response is a continuous variable.
}
\details{
This object makes use of functionality from the following packages:\itemize{  \item{\code{pls}}}
}
\section{Inheritance}{

A \code{PLSR} object inherits the following \code{struct} classes: \cr\cr
\verb{[PLSR]} >> \verb{[model]} >> \verb{[struct_class]}
}

\examples{
M = PLSR(
      number_components = 2,
      factor_name = "V1")

M = PLSR(factor_name='run_order')
}
\references{
Liland K, Mevik B, Wehrens R (2023). \emph{pls: Partial Least Squares and
Principal Component Regression}. R package version 2.8-3,
\url{https://CRAN.R-project.org/package=pls}.
}
