% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLSDA_class.R
\name{PLSDA}
\alias{PLSDA}
\title{Partial least squares discriminant analysis}
\usage{
PLSDA(number_components = 2, factor_name, pred_method = "max_prob", ...)
}
\arguments{
\item{number_components}{(numeric, integer) The number of PLS components. The default is \code{2}.\cr}

\item{factor_name}{(character) The name of a sample-meta column to use.}

\item{pred_method}{(character) Prediction method. Allowed values are limited to the following: \itemize{ \item{\code{"max_yhat"}: The predicted group is selected based on the largest value of y_hat.}\item{\code{"max_prob"}: The predicted group is selected based on the largest probability of group membership.}} The default is \code{"max_prob"}.}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A  \code{PLSDA} object with the following \code{output} slots:
\tabular{ll}{
\code{scores} \tab          (DatasetExperiment)  \cr
\code{loadings} \tab          (data.frame)  \cr
\code{yhat} \tab          (data.frame)  \cr
\code{design_matrix} \tab          (data.frame)  \cr
\code{y} \tab          (data.frame)  \cr
\code{reg_coeff} \tab          (data.frame)  \cr
\code{probability} \tab          (data.frame)  \cr
\code{vip} \tab          (data.frame)  \cr
\code{pls_model} \tab          (list)  \cr
\code{pred} \tab          (data.frame)  \cr
\code{threshold} \tab          (numeric)  \cr
\code{sr} \tab          (data.frame) Selectivity ratio for a variable represents a measure of a variable's importance in the PLS model. The output data.frame contains a column of selectivity ratios, a column of p-values based on an F-distribution and a column indicating significance at p < 0.05. \cr
\code{sr_pvalue} \tab          (data.frame) A p-value computed from the Selectivity Ratio based on an F-distribution. \cr
}
}
\description{
PLS is a multivariate regression technique that extracts latent variables maximising covariance between the input data and the response. The Discriminant Analysis variant uses group labels in the response variable. For >2 groups a 1-vs-all approach is used. Group membership can be predicted for test samples based on a probability estimate of group membership, or the estimated y-value.
}
\details{
This object makes use of functionality from the following packages:\itemize{  \item{\code{pls}}}
}
\section{Inheritance}{

A \code{PLSDA} object inherits the following \code{struct} classes: \cr\cr
\verb{[PLSDA]} >> \verb{[PLSR]} >> \verb{[model]} >> \verb{[struct_class]}
}

\examples{
M = PLSDA(
      number_components = 2,
      factor_name = "V1",
      pred_method = "max_prob")

M = PLSDA('number_components'=2,factor_name='Species')
}
\references{
Liland K, Mevik B, Wehrens R (2023). \emph{pls: Partial Least Squares and
Principal Component Regression}. R package version 2.8-3,
\url{https://CRAN.R-project.org/package=pls}.

Perez NF, Ferre J, Boque R (2009). "Calculation of the reliability of
classification in discriminant partial least-squares binary
classification." \emph{Chemometrics and Intelligent Laboratory Systems},
\emph{95}(2), 122-128.

Barker M, Rayens W (2003). "Partial least squares for discrimination."
\emph{Journal of Chemometrics}, \emph{17}(3), 166-173.
}
