% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hca_class.R
\name{HCA}
\alias{HCA}
\title{Hierarchical Cluster Analysis}
\usage{
HCA(
  dist_method = "euclidean",
  cluster_method = "complete",
  minkowski_power = 2,
  factor_name,
  ...
)
}
\arguments{
\item{dist_method}{(character) Distance measure. Allowed values are limited to the following: \itemize{ \item{\code{"euclidean"}: The euclidean distance (2 norm).}\item{\code{"maximum"}: The maximum distance.}\item{\code{"manhattan"}: The absolute distance (1 norm).}\item{\code{"canberra"}: A weighted version of the mahattan distance.}\item{\code{"minkowski"}: A generalisation of manhattan and euclidean distance to nth norm.}} The default is \code{"euclidean"}.}

\item{cluster_method}{(character) Agglomeration method. Allowed values are limited to the following: \itemize{ \item{\code{"ward.D"}: Ward clustering.}\item{\code{"ward.D2"}: Ward clustering using sqaured distances.}\item{\code{"single"}: Single linkage.}\item{\code{"complete"}: Complete linkage.}\item{\code{"average"}: Average linkage (UPGMA).}\item{\code{"mcquitty"}: McQuitty linkage (WPGMA).}\item{\code{"median"}: Median linkage (WPGMC).}\item{\code{"centroid"}: Centroid linkage (UPGMC).}} The default is \code{"complete"}.}

\item{minkowski_power}{(numeric)  The default is \code{2}.\cr}

\item{factor_name}{(character) The name of a sample-meta column to use.}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A  \code{HCA} object with the following \code{output} slots:
\tabular{ll}{
\code{dist_matrix} \tab          (dist) An object containing pairwise distance information between samples. \cr
\code{hclust} \tab          (hclust) An object of class hclust which describes the tree produced by the clustering process. \cr
\code{factor_df} \tab          (data.frame)  \cr
}
}
\description{
Hierarchical Cluster Analysis is a numerical technique that uses agglomerative clustering to identify clusters or groupings of samples.
}
\details{
This object makes use of functionality from the following packages:\itemize{  \item{\code{stats}}}
}
\section{Inheritance}{

A \code{HCA} object inherits the following \code{struct} classes: \cr\cr
\verb{[HCA]} >> \verb{[model]} >> \verb{[struct_class]}
}

\examples{
M = HCA(
      dist_method = "euclidean",
      cluster_method = "complete",
      minkowski_power = numeric(0),
      factor_name = "V1")

D = iris_DatasetExperiment()
M = HCA(factor_name='Species')
M = model_apply(M,D)

}
\references{
R Core Team (2024). \emph{R: A Language and Environment for Statistical
Computing}. R Foundation for Statistical Computing, Vienna, Austria.
\url{https://www.R-project.org/}.
}
