% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geomx_import_data.R
\name{readGeoMxFromDGE}
\alias{readGeoMxFromDGE}
\title{Import GeoMX DSP data into a spatial experiment object from DGEList object}
\usage{
readGeoMxFromDGE(dge_object, spatialCoord = NULL)
}
\arguments{
\item{dge_object}{a DGEList object (created using edgeR::DGEList).}

\item{spatialCoord}{a matrix with coordinates of samples, rowname must be cosistent with the colnames of dge_object.}
}
\value{
A SpatialExperiment object.
}
\description{
Import GeoMX DSP data into a spatial experiment object from DGEList object
}
\examples{
# making a simple DGEList object
ng <- 1000
ns <- 10
Counts <- matrix(rnbinom(ng * ns, mu = 5, size = 2), ng, ns)
rownames(Counts) <- seq(ng)
y <- edgeR::DGEList(counts = Counts, group = rep(seq(2), each = 5))

# transfer into spatial experiment object
coords <- matrix(rnorm(2 * ns), 10, 2)
spe <- readGeoMxFromDGE(dge_object = y, spatialCoord = coords)
spe

}
