% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalisation.R
\name{geomxNorm}
\alias{geomxNorm}
\title{Perform normalization to GeoMX data}
\usage{
geomxNorm(
  spe_object,
  method = c("TMM", "RPKM", "TPM", "CPM", "upperquartile", "sizefactor"),
  log = TRUE
)
}
\arguments{
\item{spe_object}{A SpatialExperiment object.}

\item{method}{Normalization method to use. Options: TMM, RPKM, TPM, CPM, upperquartile, sizefactor. RPKM and TPM require gene length information, which should be added into rowData(spe). Note that TMM here is TMM + CPM.}

\item{log}{Log-transformed or not.}
}
\value{
A SpatialExperiment object, with the second assay being the normalized count matrix. The normalised count is stored in the assay slot called "logcounts" by default.
With method TMM and sizefactor, the norm.factor will be saved in the metadata of the SpatialExperiment object.
}
\description{
Perform normalization to GeoMX data
}
\note{
The normalised count is not intended to be used directly for linear modelling. For linear modelling, it is better to include the normalized factors in the "norm.factors" column of the DGEList object.
}
\examples{
data("dkd_spe_subset")

spe_tmm <- geomxNorm(dkd_spe_subset, method = "TMM")
spe_upq <- geomxNorm(dkd_spe_subset, method = "upperquartile")
spe_deseqnorm <- geomxNorm(dkd_spe_subset, method = "sizefactor")

}
\references{
Robinson, M. D., McCarthy, D. J., & Smyth, G. K. (2010). edgeR: a Bioconductor package for differential expression analysis of digital gene expression data. Bioinformatics, 26(1), 139-140.

Love, M., Anders, S., & Huber, W. (2014). Differential analysis of count data–the DESeq2 package. Genome Biol, 15(550), 10-1186.
}
