% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R, R/accessors.R
\docType{methods}
\name{getMethod}
\alias{getMethod}
\alias{getMethod}
\alias{getMethod,stageR}
\alias{getMethod,stageRTx}
\alias{getMethod,stageRTx-method}
\title{Retrieve FWER correction method.}
\usage{
getMethod(object, ...)

\S4method{getMethod}{stageR}(object, ...)

\S4method{getMethod}{stageRTx}(object, ...)
}
\arguments{
\item{object}{an object of the \code{\link{stageRClass}} or \code{stageRTxClass} class.}

\item{...}{Additional arguments}
}
\value{
Returns a character vector of length 1 specifying the FWER correction method that is used in the confirmation stage of the stage-wise analysis.
}
\description{
This functions retrieves the method used for FWER multiple testing correction in the confirmation stage of a stage-wise analysis.
}
\section{Methods (by class)}{
\itemize{
\item \code{stageRTx}: Retrieve FWER correction method.
}}

\examples{
pScreen=c(seq(1e-10,1e-2,length.out=100),seq(1e-2,.2,length.out=100),seq(.2,1,length.out=100))
names(pScreen)=paste0("gene",1:300)
pConfirmation=matrix(runif(900),nrow=300,ncol=3)
dimnames(pConfirmation)=list(paste0("gene",1:300),c("H1","H2","H3"))
stageRObj <- stageR(pScreen=pScreen, pConfirmation=pConfirmation)
stageRObj <- stageWiseAdjustment(stageRObj, method="holm", alpha=0.05)
getMethod(stageRObj)
}
\references{
Van den Berge K., Soneson C., Robinson M.D., Clement L. (2017). stageR: a general stage-wise method for controlling the gene-level false discovery rate in differential expression and differential transcript usage. Genome Biology 18:151. https://doi.org/10.1186/s13059-017-1277-0
}
