#' Transcript-level abundance estimates in 14 Chinese prostate cancer patients
#'
#' A dataset containing 14 matched samples of tumoral prostate cancer and normal tissue, both derived from the same Chinese patient. The dataset has been prefiltered to reduce the computational burden of the vignette.
#'
#' @format An \code{ExpressionSet} object.
#' @references
#'Ren, Shancheng, Zhiyu Peng, Jian-Hua Mao, Yongwei Yu, Changjun Yin, Xin Gao, Zilian Cui, et al. 2012. "RNA-seq analysis of prostate cancer in the Chinese population identifies recurrent gene fusions, cancer-associated long noncoding RNAs and aberrant alternative splicings." Cell Research 22 (5): 806-21. doi:10.1038/cr.2012.30.
#' @source \url{http://pachterlab.github.io/lair/}
"esetProstate"

#' Hammer dataset
#'
#' A gene expression dataset from an experiment on spinal nerve ligation in rats, comparing this treatment to control samples in two timepoints, i.e. two weeks and two months post treatment. 2 Biological replicates available in every treatment x time combination.
#'
#' @format An \code{ExpressionSet} object.
#' @references
#' Hammer P, Banck MS, Amberg R, et al. mRNA-seq with agnostic splice site discovery for nervous system transcriptomics tested in chronic pain. Genome Research. 2010;20(6):847-860. doi:10.1101/gr.101204.109.
#' @source \url{http://bowtie-bio.sourceforge.net/recount/}
"hammer.eset"