% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal.R
\name{getDensityMats}
\alias{getDensityMats}
\title{Internal function: Matrix of calculations for density gating of intensity values in \code{marker} for each unique subset of \code{subset_col}}
\usage{
getDensityMats(
  intens_dat,
  marker,
  subset_col,
  bin_n = 512,
  peak_detect_ratio = 10,
  pos_peak_threshold = 1800
)
}
\arguments{
\item{intens_dat}{dataframe of pre-gated (compensated, biexp. transf, gated CD4/CD8) intensity values where
cols = intensity value per marker,
rows = each sample}

\item{marker}{string for the marker to gate on
the name needs to match exactly the column name in \code{intens_dat}}

\item{subset_col}{string for the column name to indicate the subsets to apply density gating on
will perform operation on subsets corresponding to each unique value in column}

\item{bin_n}{numeric to be passed to \code{n} parameter of \code{density(n = bin_n)} for
number of equally spaced points at which the density is to be estimated
default is 512, which is the default of \code{density(n = 512)}}

\item{peak_detect_ratio}{numeric threshold for eliminating small peaks where
a peak that is < than the highest peak by \code{peak_detect_ratio} times will be ignored
default = 10}

\item{pos_peak_threshold}{numeric for threshold to identify a positive peak
'  default is 1800, which is on the biexponential scale}
}
\value{
tibble of matrices for \code{marker} containing calculations for density gating
for each unique subset found in \code{subset_col} \cr
rows correspond to unique values in \code{subset_col}, \cr
cols correspond to the information for density gating
}
\description{
Internal function for \code{getDensityGates}
For each unique value in \code{subset_col}, there is a matrix for storing calculations for density gating
contains: first to fourth derivatives of density,
indicators for local peaks, "real peaks", plateau_pre and cutoff
}
\keyword{internal}
