% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getBiexpTransformGS.R
\name{getBiexpTransformGS}
\alias{getBiexpTransformGS}
\title{Applies Biexpeonential Transformation using specifications in csv file
provided at \code{path_biexp_params}}
\usage{
getBiexpTransformGS(gs, path_biexp_params)
}
\arguments{
\item{gs}{GatingSet to apply Biexponential Transformation to}

\item{path_biexp_params}{file path for .csv file that specifies the
Biexponential Transformation}
}
\value{
GatingSet with Biexponentially Transformed data
}
\description{
The csv file at \code{path_biexp_params} should specify the channels to apply
the transformation to and the parameters
(negative decades, width basis and positive decades).
The default is negative decades=0.5, width basis=-30 and
positive decades=4.5.
The Transformation can be applied to only a subset of the channels
included in the GatingSet.
}
\details{
An example table is provided in the extdata/biexp_transf_parameters_x50.csv
}
\examples{
# This example does not contain all the pre-processing steps required in
# getting the GatingSet (gs) ready for Biexp transformation.
# To see the steps that are required to creating the (gs),
# please see the vignette for a full tutorial

# To make this a runnable example, read in the FCS file to create gs and
# directly apply

# File path to the FCS file
path_fcs <- system.file("extdata",
                        "example_fcs.fcs",
                        package="staRgate",
                        mustWork=TRUE)
path_biexp_params <- system.file("extdata",
                                 "biexp_transf_parameters_x50.csv",
                                 package="staRgate",
                                 mustWork=TRUE)

# Create a cytoset then convert to gs
cs <- flowWorkspace::load_cytoset_from_fcs(path_fcs)
gs <- flowWorkspace::GatingSet(cs)

# gs must be a GatingSet object
gs <- getBiexpTransformGS(gs, path_biexp_params=path_biexp_params)

# To check the transformation parameters applied
flowWorkspace::gh_get_transformations(gs)
}
