% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splatPop-simulate.R
\name{splatPopSimulateSample}
\alias{splatPopSimulateSample}
\title{splatPopSimulateSample simulation}
\usage{
splatPopSimulateSample(
  params = newSplatPopParams(),
  method = c("single", "groups", "paths"),
  batch = "batch1",
  counts.only = FALSE,
  verbose = TRUE,
  sample.means,
  ...
)
}
\arguments{
\item{params}{SplatPopParams object containing parameters for population
scale simulations. See \code{\link{SplatPopParams}} for details.}

\item{method}{which simulation method to use. Options are "single" which
produces a single population, "groups" which produces distinct groups
(eg. cell types), "paths" which selects cells from continuous
trajectories (eg. differentiation processes).}

\item{batch}{Batch number.}

\item{counts.only}{logical. Whether to return only the counts.}

\item{verbose}{logical. Whether to print progress messages.}

\item{sample.means}{Gene means to use if running splatSimulatePop().}

\item{...}{any additional parameter settings to override what is provided in
\code{params}.}
}
\value{
SingleCellExperiment object containing the simulated counts and
intermediate values for one sample.
}
\description{
Simulate count data for one sample from a fictional single-cell RNA-seq
experiment using the Splat method.
}
\details{
This function closely mirrors \code{\link{splatSimulate}}. The main
difference is that it takes the means simulated by splatPopSimulateMeans
instead of randomly sampling a mean for each gene. For details about this
function see the documentation for \code{\link{splatSimulate}}.
}
\seealso{
\code{\link{splatSimLibSizes}}, \code{\link{splatPopSimGeneMeans}},
\code{\link{splatSimBatchEffects}}, \code{\link{splatSimBatchCellMeans}},
\code{\link{splatSimDE}}, \code{\link{splatSimCellMeans}},
\code{\link{splatSimBCVMeans}}, \code{\link{splatSimTrueCounts}},
\code{\link{splatSimDropout}}, \code{\link{splatPopSimulateSC}}
}
\keyword{internal}
