% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splatPop-simulate.R
\name{splatPopSimulateSC}
\alias{splatPopSimulateSC}
\title{splatPopSimulateSC}
\usage{
splatPopSimulateSC(
  sim.means,
  params,
  key,
  method = c("single", "groups", "paths"),
  counts.only = FALSE,
  conditions = NULL,
  sparsify = TRUE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{sim.means}{Matrix or list of matrices of gene means for the population.
Output from `splatPopSimulateMeans()`.}

\item{params}{SplatPopParams object containing parameters for population
scale simulations. See \code{\link{SplatPopParams}} for details.}

\item{key}{data.frame object containing a full or partial splatPop key.
Output from `splatPopSimulateMeans()`.}

\item{method}{which simulation method to use. Options are "single" which
produces a single cell population for each sample, "groups" which
produces distinct groups (eg. cell types) for each sample (note, this
creates separate groups from those created in `popSimulate` with only
DE effects), and "paths" which selects cells from continuous
trajectories (eg. differentiation processes).}

\item{counts.only}{logical. Whether to return only the counts.}

\item{conditions}{named array with conditional group assignment for each
sample. Output from `splatPopSimulateMeans()`.}

\item{sparsify}{logical. Whether to automatically convert assays to sparse
matrices if there will be a size reduction.}

\item{verbose}{logical. Whether to print progress messages.}

\item{...}{any additional parameter settings to override what is provided in
\code{params}.}
}
\value{
SingleCellExperiment object containing simulated counts,
intermediate values like the gene means simulated in `splatPopSimulateMeans`,
and information about the differential expression and eQTL effects assigned
to each gene.
}
\description{
Simulate count data for a population from a fictional single-cell
RNA-seq experiment using the Splat method.
}
\examples{
\donttest{
if (requireNamespace("VariantAnnotation", quietly = TRUE) &&
    requireNamespace("preprocessCore", quietly = TRUE)) {
    params <- newSplatPopParams()
    sim.means <- splatPopSimulateMeans()
    sim <- splatPopSimulateSC(sim.means$means, params, sim.means$key)
}
}

}
