% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scDD-simulate.R
\name{scDDSimulate}
\alias{scDDSimulate}
\title{scDD simulation}
\usage{
scDDSimulate(
  params = newSCDDParams(),
  plots = FALSE,
  plot.file = NULL,
  sparsify = TRUE,
  verbose = TRUE,
  BPPARAM = SerialParam(),
  ...
)
}
\arguments{
\item{params}{SCDDParams object containing simulation parameters.}

\item{plots}{logical. whether to generate scDD fold change and validation
plots.}

\item{plot.file}{File path to save plots as PDF.}

\item{sparsify}{logical. Whether to automatically convert assays to sparse
matrices if there will be a size reduction.}

\item{verbose}{logical. Whether to print progress messages}

\item{BPPARAM}{A \code{\link[BiocParallel]{BiocParallelParam}} instance
giving the parallel back-end to be used. Default is
\code{\link[BiocParallel]{SerialParam}} which uses a single core.}

\item{...}{any additional parameter settings to override what is provided in
\code{params}.}
}
\value{
SingleCellExperiment containing simulated counts
}
\description{
Simulate counts using the scDD method.
}
\details{
This function is just a wrapper around \code{\link[scDD]{simulateSet}} that
takes a \code{\link{SCDDParams}}, runs the simulation then converts the
output to a \code{\link[SingleCellExperiment]{SingleCellExperiment}} object.
See \code{\link[scDD]{simulateSet}} for more details about how the simulation
works.
}
\examples{
\donttest{
sim <- scDDSimulate()
}
}
\references{
Korthauer KD, Chu L-F, Newton MA, Li Y, Thomson J, Stewart R, et al. A
statistical approach for identifying differential distributions in
single-cell RNA-seq experiments. Genome Biology (2016).

Paper: \url{10.1186/s13059-016-1077-y}

Code: \url{https://github.com/kdkorthauer/scDD}
}
