% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{makeCompPanel}
\alias{makeCompPanel}
\title{Make comparison panel}
\usage{
makeCompPanel(
  comp,
  title = "Comparison",
  labels = c("Means", "Variance", "Mean-variance relationship", "Library size",
    "Zeros per gene", "Zeros per cell", "Mean-zeros relationship")
)
}
\arguments{
\item{comp}{list returned by \code{\link{compareSCEs}}.}

\item{title}{title for the panel.}

\item{labels}{vector of labels for each of the seven plots.}
}
\value{
Combined panel plot
}
\description{
Combine the plots from \code{compareSCEs} into a single panel.
}
\examples{
\donttest{
sim1 <- splatSimulate(nGenes = 1000, batchCells = 20)
sim2 <- simpleSimulate(nGenes = 1000, nCells = 20)
comparison <- compareSCEs(list(Splat = sim1, Simple = sim2))
panel <- makeCompPanel(comparison)
}

}
