% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kersplat-simulate.R
\name{kersplatSetup}
\alias{kersplatSetup}
\title{Kersplat setup}
\usage{
kersplatSetup(params = newKersplatParams(), verbose = TRUE, ...)
}
\arguments{
\item{params}{KersplatParams object containing simulation parameters.}

\item{verbose}{logical. Whether to print progress messages}

\item{...}{any additional parameter settings to override what is provided in
\code{params}.}
}
\value{
A complete KersplatParams object
}
\description{
Setup the parameters required for the Kersplat simulation
}
\details{
The first stage is a two-step Kersplat simulation is to generate some of the
intermediate parameters. The resulting parameters allow multiple simulated
datasets to be generated from the same biological structure (using
\code{\link{kersplatSample}}). As with all the other parameters these values
can be manually overwritten if desired.

The setup involves the following steps:
\enumerate{
    \item Generate a gene network (if not already present)
    \item Select regulator genes (if not already present)
    \item Simulate gene means (if not already present)
    \item Simulate cell paths
}

The resulting \code{\link{KersplatParams}} object will have the following
parameters set (if they weren't already).

\itemize{
    \item \code{mean.values}
    \item \code{network.graph}
    \item \code{network.regsSet}
    \item \code{paths.means}
}

See \code{\link{KersplatParams}} for more details about these parameters and
the functions for the individual steps for more details about the process.
}
\examples{

if (requireNamespace("igraph", quietly = TRUE)) {
    params <- kersplatSetup()
}
}
\seealso{
\code{\link{kersplatGenNetwork}}, \code{\link{kersplatSelectRegs}},
\code{\link{kersplatSimGeneMeans}}, \code{\link{kersplatSimPaths}},
\code{\link{KersplatParams}}
}
