% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotImage.R
\name{plotImage}
\alias{plotImage}
\title{Plots an image with specified from and to cell types.}
\usage{
plotImage(
  cells,
  imageToPlot,
  from,
  to,
  imageID = "imageID",
  cellType = "cellType",
  spatialCoords = c("x", "y")
)
}
\arguments{
\item{cells}{A SummarizedExperiment object.}

\item{imageToPlot}{The ID of the image to be plotted.}

\item{from}{The "from" cell type.}

\item{to}{The "to" cell type.}

\item{imageID}{The name of the imageID column in the SummarizedExperiment object.}

\item{cellType}{The name of the cellType column in the SummarizedExperiment object.}

\item{spatialCoords}{The names of the spatialCoords column if using a SingleCellExperiment.}
}
\value{
A ggplot object.
}
\description{
Plots an image with specified from and to cell types.
}
\examples{
data("diabetesData")
plotImage(diabetesData, "A09", from = "acinar", to = "alpha")

}
