% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_svg.R
\name{read_svg}
\alias{read_svg}
\title{Parsing annotated SVG (aSVG) files}
\usage{
read_svg(svg.path, raster.path = NULL, cores = 1, srsc = FALSE)
}
\arguments{
\item{svg.path}{A vector of one or multiple paths of aSVG files. If multiple aSVGs, such as aSVGs depicting organs development across mutiple times, the aSVGs should be indexed with suffixes "_shm1", "_shm2", ..., such as "arabidopsis.thaliana_organ_shm1.svg", "arabidopsis.thaliana_organ_shm2.svg".}

\item{raster.path}{\itemize{ \item A vector of one or multiple paths of raster images in form of jpg or png, which are usually used as templates for creating aSVG images in \code{svg.path}. Optional (default is \code{NULL}), only applicable when superimposing raster images with SHM plots that are created from aSVG images. \item Matching raster and aSVG images is indicated by identical base names such as imageA.png and imageA.svg. The layout order in SHMs composed of multiple independent images is controlled by numbering the corresponding file pairs accordingly such as imageA_1.png and imageA_1.svg, imageB_2.png and imageB_2.svg, etc.}}

\item{cores}{Number of CPUs to parse the aSVG files (default is \code{1}).}

\item{srsc}{Logical. If `TRUE`, the aSVG is considered for co-visualizing spatially resolved single-cell and bulk data, and the rotation angle of the tissue section for spatial assays will be recorded.}
}
\value{
An object of \code{SVG} class, containing one or multiple aSVG instances.
}
\description{
Parse one or multiple aSVG files and store their coordinates and related attributes in an \code{SVG} container, which will be used for creating spatial heatmap (SHM) plots.
}
\examples{

# The first raste image used as a template to create an aSVG. 
raster.pa1 <- system.file('extdata/shinyApp/data/maize_leaf_shm1.png',
package='spatialHeatmap')
# The first aSVG created with the first template. 
svg.pa1 <- system.file('extdata/shinyApp/data/maize_leaf_shm1.svg',
package='spatialHeatmap')
# The second raster image used as a template to create an aSVG. 
raster.pa2 <- system.file('extdata/shinyApp/data/maize_leaf_shm2.png',
package='spatialHeatmap')
# The second aSVG created with the second template. 
svg.pa2 <- system.file('extdata/shinyApp/data/maize_leaf_shm2.svg',
package='spatialHeatmap')

# Parse these two aSVGs without association with raster images.
svgs <- read_svg(svg.path=c(svg.pa1, svg.pa2), raster.path=NULL)
# Parse these two aSVGs. The raster image paths are provide so as to
# be associated with respective aSVGs, which will be used when 
# superimposing raster images with SHM plots.
svgs <- read_svg(svg.path=c(svg.pa1, svg.pa2), raster.path=c(raster.pa1, raster.pa2))
}
\references{
Hadley Wickham, Jim Hester and Jeroen Ooms (2019). xml2: Parse XML. R package version 1.2.2. https://CRAN.R-project.org/package=xml2
}
\seealso{
\code{\link{SVG}}: the \code{SVG} class.
}
\author{
Jianhai Zhang \email{jzhan067@ucr.edu} \cr Dr. Thomas Girke \email{thomas.girke@ucr.edu}
}
