% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeneSetDb-methods.R
\name{is.active}
\alias{is.active}
\title{Interrogate "active" status of a given geneset.}
\usage{
is.active(x, i, j)
}
\arguments{
\item{x}{\code{\link[=GeneSetDb]{GeneSetDb()}}}

\item{i}{collection of geneset(s)}

\item{j}{name of geneset(s) (must be same length as \code{i}.}
}
\value{
logical indicating if geneset is active. throws an error if
any requested geneset does not exist in \code{x}.
}
\description{
Returns the \code{active} status of genesets, which are specified by
their collection,name compound keys. This function is vectorized and
supports query of multiple gene sets at a time. If a requested
collection,name gene set doesn't exist, this throws an error.
}
\examples{
dge.stats <- exampleDgeResult()
y <- exampleExpressionSet(do.voom = FALSE)
gdb <- conform(exampleGeneSetDb(), y, min.gs.size = 10)
# size 9 geneset:
geneSet(gdb, "c2", "BYSTRYKH_HEMATOPOIESIS_STEM_CELL_IL3RA")
is.active(gdb, "c2", "BYSTRYKH_HEMATOPOIESIS_STEM_CELL_IL3RA")
# geneset with >100 genes
is.active(gdb, "c7", "GSE3982_MAC_VS_NEUTROPHIL_LPS_STIM_DN")
}
