% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/GeneSetDb-methods.R,
%   R/SparrowResult-methods.R
\name{collectionMetadata}
\alias{collectionMetadata}
\alias{geneSetURL}
\alias{featureIdType}
\alias{featureIdType<-}
\alias{collectionMetadata,GeneSetDb,missing,missing-method}
\alias{collectionMetadata,GeneSetDb,character,missing-method}
\alias{collectionMetadata,GeneSetDb,character,character-method}
\alias{geneSetURL,GeneSetDb-method}
\alias{featureIdType<-,GeneSetDb-method}
\alias{featureIdType,GeneSetDb-method}
\alias{addCollectionMetadata}
\alias{geneSetURL,SparrowResult-method}
\title{Gene Set Collection Metadata}
\usage{
collectionMetadata(x, collection, name, ...)

geneSetURL(x, i, j, ...)

featureIdType(x, i, ...)

featureIdType(x, i) <- value

\S4method{collectionMetadata}{GeneSetDb,missing,missing}(x, collection, name, as.dt = FALSE)

\S4method{collectionMetadata}{GeneSetDb,character,missing}(x, collection, name, as.dt = FALSE)

\S4method{collectionMetadata}{GeneSetDb,character,character}(x, collection, name, as.dt = FALSE)

\S4method{geneSetURL}{GeneSetDb}(x, i, j, ...)

\S4method{featureIdType}{GeneSetDb}(x, i) <- value

\S4method{featureIdType}{GeneSetDb}(x, i, ...)

addCollectionMetadata(
  x,
  xcoll,
  xname,
  value,
  validate.value.fn = NULL,
  allow.add = TRUE
)

\S4method{geneSetURL}{SparrowResult}(x, i, j, ...)
}
\arguments{
\item{x}{\code{\link[=GeneSetDb]{GeneSetDb()}}}

\item{collection}{The geneset collection to to query}

\item{name}{The name of the metadata variable to get the value for}

\item{...}{not used yet}

\item{i, j}{The collection,name compound key identifier of the gene set}

\item{value}{The value of the metadata variable}

\item{as.dt}{If \code{FALSE} (default), the data.frame like thing that
this funciton returns will be set to a data.frame. Set this to \code{TRUE}
to keep this object as a \code{data.table}}

\item{xcoll}{The collection name}

\item{xname}{The name of the metadata variable}

\item{validate.value.fn}{If a function is provided, it is run on
\code{value} and msut return \code{TRUE} for addition to be made}

\item{allow.add}{If \code{FALSE}, this xcoll,xname should be in the
\code{GeneSetDb} already, and this will fail because something is
deeply wrong with the world}
}
\value{
A character vector of URLs for each of the genesets identified by
\verb{i, j}. \code{NA} is returned for genesets \verb{i,j} that are not found in \code{x}.

The updated \code{GeneSetDb}.
}
\description{
Associates key:value metadata to a gene set collection of a \code{\link[=GeneSetDb]{GeneSetDb()}}.
}
\details{
The design of the GeneSetDb is such that we assume that groups of gene sets
are usually defined together and will therefore share similar metadata.
These groups of gene sets will fall into the same "collection", and,
therefore, metadata for particular gene sets are tracked at the collection
level.

Types of metadata being referred to could be things like the organism
that a batch of gene sets were defined in, the type of feature identifiers
that a collection of gene sets are using (ie. \code{\link[GSEABase:GeneIdentifierType-constructors]{GSEABase::EntrezIdentifier()}})
or a URL pattern that combines the collection,name compound key that one
can browse to in order to find out more information about the gene set.

There are explicit helper functions that set and get these aforementioned
metadata, namely \code{featureIdType()}, \code{geneSetCollectionURLfunction()}, and
\code{geneSetURL()}. Aribtrary metadata can be stored at the collection level
using the \code{\link[=addCollectionMetadata]{addCollectionMetadata()}} function. More details are provided
below.
}
\section{Methods (by class)}{
\itemize{
\item \code{collectionMetadata(x = GeneSetDb, collection = missing, name = missing)}: Returns metadata for all collections

\item \code{collectionMetadata(x = GeneSetDb, collection = character, name = missing)}: Returns all metadata for a specific collection

\item \code{collectionMetadata(x = GeneSetDb, collection = character, name = character)}: Returns the \code{name} metadata value for a given
\code{collection}.

\item \code{geneSetURL(GeneSetDb)}: returns the URL for a geneset

\item \code{featureIdType(GeneSetDb) <- value}: sets the feature id type for a collection

\item \code{featureIdType(GeneSetDb)}: retrieves the feature id type for a collection

\item \code{geneSetURL(SparrowResult)}: returns the URL for a geneset from a
SparrowResult object

}}
\section{Gene Set URLs}{


A URL function can be defined per collection that takes the collection,name
compound key and generates a URL for the gene set that the user can browse
to for futher information. For instance, the
\code{geneSetCollectionURLfunction()} for the MSigDB collections are defined
like so:

\if{html}{\out{<div class="sourceCode">}}\preformatted{url.fn <- function(collection, name) \{
  url <- 'http://www.broadinstitute.org/gsea/msigdb/cards/\%s.html'
  sprintf(url, name)
\}
gdb <- getMSigGeneSetDb('H')
geneSetCollectionURLfunction(gdb, 'H') <- url.fn
}\if{html}{\out{</div>}}

In this way, a call to \code{geneSetURL(gdb, 'H', 'HALLMARK_ANGIOGENESIS')}
will return
http://www.broadinstitute.org/gsea/msigdb/cards/HALLMARK_ANGIOGENESIS.html.

This function is vectorized over \code{i} and \code{j}
}

\section{Feature ID Types}{


When defining a set of gene sets in a collection, the identifiers used must
be of the same type. Most often you'll probably be working with Entrez
identifiers, simply because that's what most of the annotations work with.

As such, you'd define that your collection uses geneset identifiers like
so:

\if{html}{\out{<div class="sourceCode">}}\preformatted{gdb <- getMSigGeneSetDb('H')
featureIdType(gdb, 'H') <- "ensembl"
## or, equivalently (but you don't want to use this)
gdb <- addCollectionMetadata(gdb, 'H', 'id_type', "ensembl")
}\if{html}{\out{</div>}}
}

\section{Adding arbitrary collectionMetadata}{


Adds arbitrary metadata to a gene set collection of a GeneSetDb

Note that this is not a replacement method! You must catch the returned
object to keep the one with the updated \code{collectionMetadata}. Although this
function is exported, I imagine this being used mostly through predefined
replace methods that use this as a utility function, such as the replacement
methods \verb{featureIdType<-}, \verb{geneSetURLfunction<-}, etc.

\if{html}{\out{<div class="sourceCode">}}\preformatted{gdb <- getMSigGeneSetDb('H')
gdb <- addCollectionMetadata(gdb, 'H', 'foo', 'bar')
}\if{html}{\out{</div>}}
}

\examples{
gdb <- exampleGeneSetDb()

# Gene Set URLs
geneSetURL(gdb, 'c2', 'BIOCARTA_AGPCR_PATHWAY')
geneSetURL(gdb, c('c2', 'c7'),
           c('BIOCARTA_AGPCR_PATHWAY', 'GSE14308_TH2_VS_TH1_UP'))

# feature id types
featureIdType(gdb, "c2") <- "entrez" # GSEABase::EntrezIdentifier()
featureIdType(gdb, "c2")

## Arbitrary metadata
gdb <- addCollectionMetadata(gdb, 'c2', 'foo', 'bar')
cmh <- collectionMetadata(gdb, 'c2', as.dt = TRUE) ## print this to see
}
